# Recolic CERNET proxy service:
# dssl.cun.io is not available in public Internet. So you have to use my proxy: cernet.cnm.cool.
# If variable is not set, use original version.
[ "$hust_submit_server_host" = "" ] && hust_submit_server_host=dssl.cun.io

function env_set() {
    sed -i -e "/^export $2=.*/d" ~/.bashrc
    echo "export $2=`readlink -e $1`" >> ~/.bashrc
}

[ -z ${STUID} ]   && echo "STUID must be set (RTFM)"   && exit
[ -z ${STUNAME} ] && echo "STUNAME must be set (RTFM)" && exit

[ -z "$pubkey" ] && pubkey="${HOME}/.ssh/id_rsa.pub"
[ ! -f "$pubkey" ] && echo "Public key file $pubkey doesnt exist." && exit 2

echo "uploading public key $pubkey..."
echo curl -F "id=${STUID}" -F "name=${STUNAME}" -F "file=@$pubkey" "https://$hust_submit_server_host/teach/api/uploads/pasetup"
curl -F "id=${STUID}" -F "name=${STUNAME}" -F "file=@$pubkey" "https://$hust_submit_server_host/teach/api/uploads/pasetup" -v ||
    (echo 'ERROR: Upload failed. Recolic proxy server is in HongKong and it"s slow, so you may try again.' ; exit 2)
sleep 5
echo "setup git-remote..."
git remote add hustpa "pa@$hust_submit_server_host:${STUID}-git"
git branch pa0
git branch pa1
git branch pa2
git branch pa3
git branch pa4
git branch pa5
git push hustpa pa0
git push hustpa pa1
git push hustpa pa2
git push hustpa pa3
git push hustpa pa4
git push hustpa pa5
git branch -u hustpa/pa0 pa0
git branch -u hustpa/pa1 pa1
git branch -u hustpa/pa2 pa2
git branch -u hustpa/pa3 pa3
git branch -u hustpa/pa4 pa4
git branch -u hustpa/pa5 pa5
echo "set ENV ..."
env_set nemu NEMU_HOME
env_set nexus-am AM_HOME
env_set navy-apps NAVY_HOME
source ~/.bashrc
echo "done!"
