%option noyywrap

%{

#define YY_DECL int yylex()

#include "parser.tab.h"
#include <stdint.h>
#include <stdexcept>

%}

%%

[ \t\n]       {}
0[xX][0-9a-f]+      {yylval.ival = (int)strtol(yytext, NULL, 16); return T_INT;}
[0-9]+        {yylval.ival = atoi(yytext); return T_INT;}
"=="          {return T_EQUAL;}
"!="          {return T_NEQUAL;}
"&&"          {return T_LOGICAL_AND;}
[-+*/()]      {return yytext[0];}

"%"[a-z]{3}   {yylval.ival = ((uint32_t)yytext[2] << 8) + yytext[3]; return T_REG;}
"$"[a-z]{3}   {yylval.ival = ((uint32_t)yytext[2] << 8) + yytext[3]; return T_REG;}
.             {throw std::runtime_error(std::string("lexer error around token: ") + yytext);}
%%
// Registers: eax='a'+'x', ebx='b'+'x', ...
