#!/bin/bash

xflags="-no-ansi-alias -DDISABLE_MMIO -no-complex-limited-range -qopt-prefetch=2"
cpus=$(grep -c '^processor' /proc/cpuinfo)

make clean &&
make EXTRA_FLAGS="$xflags -prof-gen" CXX=icpc -j$cpus &&
make -C "$AM_HOME/apps/microbench" ARCH=x86-nemu &&
build/nemu -b "$AM_HOME/apps/microbench/build/microbench-x86-nemu.bin" &&
make clean &&
make EXTRA_FLAGS="$xflags -prof-use" CXX=icpc -j$cpus

exit $?

