#ifndef _HUST___PARSER_HPP
#define _HUST___PARSER_HPP 1

#include <reflected_impl.hpp>
#include <list>
#include <string>
#include <iomanip>

#include <rlib/stdio.hpp>
#include <rlib/terminal.hpp>

using namespace rlib::terminal;

class parser
{
private:
    static void help_msg()
    {
        std::string msg = R"_STR_(
Select [size_t i] -> null
List -> null
CreateAVLSet -> null
DestroyAVLSet -> null
insert [dataref_t what] -> null
rm [dataref_t what] -> null
ls -> null
merge [size_t another] -> null
sub [size_t to_sub] -> null
common [size_t another] -> null
contains [size_t another] -> bool
equal [size_t another] -> bool
dump -> null
clear -> null)_STR_";
        rlib::println(msg);
    }

public:
    static void parse(const std::vector<std::string> &to_parse)
    {
        if (to_parse.empty())
            return;
        rlib::print(std::boolalpha);

#define AREA_BEGIN if(to_parse.begin()->empty()) {}
#define IFCMD(str) else if(*to_parse.begin() == str)
#define AREA_END else

#define WANT_ARG(n) if(to_parse.size() != n+1) {throw std::runtime_error(rlib::format_string("{} arguments wanted but {} provided.", n, to_parse.size()-1));}
#define STRING_ARG(n) to_parse[n]
#define SIZE_ARG(n) std::stoul(to_parse[n])
#define INT_ARG(n) std::stoi(to_parse[n])
#define HAVE_RETURN_VALUE auto ret =
#define PRINT_RETURN_VALUE rlib::println(ret);

        AREA_BEGIN
//__ccgen_managed_begin__

//Code generated by ccgen.py below. Do not edit them by hand.
//__ccgen_debug__: `ret name(args)` is `null Select(size_t i)`
    IFCMD("Select") {
        WANT_ARG(1)
        impl.Select(SIZE_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null List()`
    IFCMD("List") {
        WANT_ARG(0)
        impl.List();
    }
//__ccgen_debug__: `ret name(args)` is `null CreateAVLSet()`
    IFCMD("CreateAVLSet") {
        WANT_ARG(0)
        impl.CreateAVLSet();
    }
//__ccgen_debug__: `ret name(args)` is `null DestroyAVLSet()`
    IFCMD("DestroyAVLSet") {
        WANT_ARG(0)
        impl.DestroyAVLSet();
    }
//__ccgen_debug__: `ret name(args)` is `null insert(dataref_t what)`
    IFCMD("insert") {
        WANT_ARG(1)
        impl.insert(INT_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null rm(dataref_t what)`
    IFCMD("rm") {
        WANT_ARG(1)
        impl.rm(INT_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null ls()`
    IFCMD("ls") {
        WANT_ARG(0)
        impl.ls();
    }
//__ccgen_debug__: `ret name(args)` is `null merge(size_t another)`
    IFCMD("merge") {
        WANT_ARG(1)
        impl.merge(SIZE_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null sub(size_t to_sub)`
    IFCMD("sub") {
        WANT_ARG(1)
        impl.sub(SIZE_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null common(size_t another)`
    IFCMD("common") {
        WANT_ARG(1)
        impl.common(SIZE_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `bool contains(size_t another)`
    IFCMD("contains") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.contains(SIZE_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `bool equal(size_t another)`
    IFCMD("equal") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.equal(SIZE_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `null clear()`
    IFCMD("clear") {
        WANT_ARG(0)
        impl.clear();
    }
//__ccgen_debug__: `ret name(args)` is `null dump()`
    IFCMD("dump") {
        WANT_ARG(0)
        impl.dump();
    }

    IFCMD("exit") {
        rlib::println("bye~");
        ::std::exit(0);
    }
    IFCMD("help") {
        help_msg();
    }
//impl.debug();
//Code generated by ccgen.py above. Do not edit them by hand.

//__ccgen_managed_end__
        AREA_END
        {
            throw std::invalid_argument("Invalid argument. Try to type `help` to get helped.");
        }


    }
};

#endif //_HUST___PARSER_HPP
