/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.proj.Project;
import edu.cornell.cs3410.ProgramAssembler;

public class ProgramState
implements InstanceData,
Cloneable {
    ProgramAssembler.Listing code;
    int pc;
    private Project proj;
    private Instance instance;
    private static final int PC_UNDEFINED = -1;
    private static final int PC_ERROR = -2;
    private static final BitWidth OP_WIDTH = BitWidth.create((int)32);

    public static ProgramState get(InstanceState state, ProgramAssembler.Listing code) {
        ProgramState ret = (ProgramState)state.getData();
        Instance instance = state.getInstance();
        if (ret == null) {
            ret = new ProgramState(code);
            state.setData((InstanceData)ret);
        }
        if (ret.code != code) {
            ret.code = code;
            code.setListener(ret);
        }
        if (ret.instance != instance) {
            ret.instance = instance;
        }
        return ret;
    }

    private ProgramState(ProgramAssembler.Listing code) {
        this.code = code;
        if (code != null) {
            code.setListener(this);
        }
        this.pc = -1;
    }

    public Project getProject() {
        return this.proj;
    }

    public void setProject(Project p) {
        this.proj = p;
    }

    public void codeChanged() {
        if (this.instance != null) {
            this.instance.fireInvalidated();
        }
    }

    String decode(int i) {
        return ProgramAssembler.disassemble(this.code.instr(i), 4 * i);
    }

    Value instr() {
        if (this.code == null) {
            return Value.createKnown((BitWidth)OP_WIDTH, (int)0);
        }
        if (this.isValidPC()) {
            return Value.createKnown((BitWidth)OP_WIDTH, (int)this.code.instr(this.pc));
        }
        return Value.createError((BitWidth)OP_WIDTH);
    }

    boolean haveCodeFor(int i) {
        return this.code.segmentOf(i) != null;
    }

    boolean isValidPC() {
        return this.pc >= 0;
    }

    boolean isUndefinedPC() {
        return this.pc == -1;
    }

    boolean isErrorPC() {
        return this.pc == -2;
    }

    public ProgramState clone() {
        try {
            return (ProgramState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void update(Value pc_in) {
        this.pc = pc_in.isErrorValue() ? -2 : (!pc_in.isFullyDefined() ? -1 : ((pc_in.toIntValue() & 3) != 0 ? -2 : pc_in.toIntValue() >>> 2));
    }
}

