/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import edu.cornell.cs3410.ProgramState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramAssembler {
    private static final int NO_OP = 0;
    private static Pattern pat0 = Pattern.compile("\\s+");
    private static Pattern pat1 = Pattern.compile("\\s*,\\s*");
    static String _reg = "\\$(\\d+|zero|at|v[01]|a[0-3]|t[0-9]|s[0-7]|k[01]|gp|sp|fp|ra)";
    static String __hex = "0x[a-fA-F0-9]+";
    static String __decimal = "-?\\d+";
    static String __label = "[a-zA-Z]\\w*";
    static String _imm = "(" + __hex + "|" + __decimal + "|" + __label + ")";
    static Pattern pat_label = Pattern.compile("(" + __label + ")");
    static HashMap<String, Command> cmds = new HashMap();
    static HashMap<Integer, Command> opcodes = new HashMap();
    static HashMap<Integer, Command> fcodes = new HashMap();
    static HashMap<Integer, Command> socodes = new HashMap();
    static Pattern pat_word = Pattern.compile(_imm);
    static Pattern pat_arith_imm = Pattern.compile(_reg + "," + _reg + "," + _imm);
    static Pattern pat_lui = Pattern.compile(_reg + "," + _imm);
    static Pattern pat_mem = Pattern.compile(_reg + "," + _imm + "\\(" + _reg + "\\)");
    static Pattern pat_br = Pattern.compile(_reg + "," + _reg + "," + _imm);
    static Pattern pat_bz = Pattern.compile(_reg + "," + _imm);
    static Pattern pat_j0 = Pattern.compile(_imm);
    static Pattern pat_arith_reg = Pattern.compile(_reg + "," + _reg + "," + _reg);
    static Pattern pat_shift_c = Pattern.compile(_reg + "," + _reg + "," + _imm);
    static Pattern pat_shift_v = Pattern.compile(_reg + "," + _reg + "," + _reg);
    static Pattern pat_jr = Pattern.compile(_reg);
    static Pattern pat_jalr = Pattern.compile(_reg + "(?:," + _reg + ")?");
    static Pattern pat_regimm = Pattern.compile(_reg + "," + _imm);

    private ProgramAssembler() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: ProgramAssembler <mips-asm-file>");
            System.exit(1);
        }
        Listing code = new Listing();
        try {
            code.load(new File(args[0]));
            for (Segment segment : code.seg) {
                for (int i = 0; i < segment.data.length; ++i) {
                    int pc = segment.start_pc + i;
                    int instr = code.instr(pc);
                    System.out.println(ProgramAssembler.toHex(pc * 4, 8) + " : " + ProgramAssembler.toHex(instr, 8) + " : " + ProgramAssembler.disassemble(instr, pc * 4));
                }
                System.out.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String toHex(int i, int digits) {
        String s;
        if (digits > 8) {
            digits = 8;
        }
        if ((s = Long.toHexString((long)i & 0xFFFFFFFFL)).length() >= digits) {
            return "0x" + s;
        }
        return "0x00000000".substring(0, 2 + digits - s.length()) + s;
    }

    private static String readFully(File file) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buf.append(line + "\n");
        }
        return buf.toString();
    }

    private static ArrayList<String> splitLines(String src) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new StringReader(src));
        ArrayList<String> buf = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            buf.add(line);
        }
        return buf;
    }

    private static ArrayList<String> normalize(ArrayList<String> lines) {
        ArrayList<String> res = new ArrayList<String>();
        for (int lineno = 0; lineno < lines.size(); ++lineno) {
            String line = lines.get(lineno);
            int i = line.indexOf(35);
            if (i == 0) {
                line = "";
            } else if (i > 0) {
                line = line.substring(0, i);
            }
            line = line.trim();
            line = pat0.matcher(line).replaceAll(" ");
            line = pat1.matcher(line).replaceAll(",");
            if (line.length() == 0) {
                res.add(null);
                continue;
            }
            res.add(line);
        }
        return res;
    }

    private static int parseSegmentAddress(int lineno, String addr) throws IOException {
        if (addr.toLowerCase().startsWith("0x")) {
            return Integer.parseInt(addr.substring(2), 16);
        }
        char c = addr.charAt(0);
        if (c >= '0' && c <= '9') {
            return Integer.parseInt(addr);
        }
        throw new ParseException("Line " + (lineno + 1) + ": illegal address '" + addr + "' in assembly directive");
    }

    private static HashMap<String, Integer> pass1(ArrayList<String> lines, int start_address, ArrayList<Integer> addr_map) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int addr = start_address;
        addr_map.clear();
        ParseException err = new ParseException();
        for (int lineno = 0; lineno < lines.size(); ++lineno) {
            int i;
            String line = lines.get(lineno);
            if (line == null) {
                addr_map.add(null);
                continue;
            }
            if (line.toLowerCase().startsWith(".text")) {
                i = line.indexOf(32);
                if (i > 0) {
                    try {
                        int a = ProgramAssembler.parseSegmentAddress(lineno, line.substring(i + 1));
                        if ((a & 3) != 0) {
                            err.add("Line " + (lineno + 1) + ": mis-aligned address '" + line.substring(i + 1) + "' in .text assembly directive");
                        }
                        addr = a & 0xFFFFFFFC;
                    }
                    catch (ParseException e) {
                        err.add(e);
                    }
                }
                addr_map.add(null);
                continue;
            }
            if (line.toLowerCase().startsWith(".word")) {
                addr_map.add(new Integer(addr));
                addr += 4;
                continue;
            }
            if (line.startsWith(".")) {
                err.add("Line " + (lineno + 1) + ": unrecognized assembly directive '" + line + "'");
                continue;
            }
            i = line.indexOf(58);
            if (i >= 0) {
                String name = line.substring(0, i).trim();
                if (name.length() == 0) {
                    err.add("Line " + (lineno + 1) + ": expected label name before ':'");
                    continue;
                }
                Matcher m = pat_label.matcher(name);
                if (name.equalsIgnoreCase("pc") || !m.matches()) {
                    err.add("Line " + (lineno + 1) + ": illegal label name '" + name + "' before ':'");
                    continue;
                }
                map.put(name, new Integer(addr));
                if (i < line.length() - 1) {
                    line = line.substring(i + 1).trim();
                    lines.set(lineno, line);
                    addr_map.add(new Integer(addr));
                    addr += 4;
                    continue;
                }
                addr_map.add(null);
                lines.set(lineno, null);
                continue;
            }
            addr_map.add(new Integer(addr));
            addr += 4;
        }
        if (err.getCount() > 0) {
            throw err;
        }
        return map;
    }

    private static int resolve(int lineno, String imm, int addr, HashMap<String, Integer> sym, Type type, int nbits) throws IOException {
        int offset = type == Type.SIGNED_RELATIVE ? addr + 4 : 0;
        long min = type == Type.UNSIGNED_ABSOLUTE ? 0L : -1L << nbits - 1;
        long max = type == Type.UNSIGNED_ABSOLUTE ? (1L << nbits) - 1L : (1L << nbits - 1) - 1L;
        int mask = (int)(1L << nbits) - 1;
        try {
            long val;
            if (imm.length() == 0) {
                throw new NumberFormatException();
            }
            char c = imm.charAt(0);
            if (imm.equalsIgnoreCase("pc")) {
                val = ((long)addr & 0xFFFFFFFFL) - (long)offset;
            } else {
                if (imm.toLowerCase().startsWith("0x")) {
                    long val2 = Long.parseLong(imm.substring(2), 16);
                    if ((val2 & (long)mask) != val2) {
                        throw new ParseException("Line " + (lineno + 1) + ": overflow in " + (Object)((Object)type) + " '" + imm + "' (" + nbits + " bits maximum)");
                    }
                    return (int)(val2 & (long)mask);
                }
                if (c == '-' || c >= '0' && c <= '9') {
                    val = Long.parseLong(imm);
                } else {
                    Integer a = sym.get(imm);
                    if (a == null) {
                        throw new ParseException("Line " + (lineno + 1) + ": expecting " + (Object)((Object)type) + ", but no such label or number '" + imm + "'");
                    }
                    val = ((long)a.intValue() & 0xFFFFFFFFL) - (long)offset;
                    imm = imm + " (" + val + ")";
                }
            }
            if (type == Type.ANY_ABSOLUTE) {
                if ((val & (long)mask) != val) {
                    throw new ParseException("Line " + (lineno + 1) + ": overflow in " + (Object)((Object)type) + " '" + imm + "' (" + nbits + " bits maximum)");
                }
            } else if (val < min || val > max) {
                throw new ParseException("Line " + (lineno + 1) + ": overflow in " + (Object)((Object)type) + " '" + imm + "' : allowed range is " + min + " (" + ProgramAssembler.toHex((int)min & mask, 1) + ") to " + max + " (" + ProgramAssembler.toHex((int)max & mask, 1) + ")");
            }
            return (int)(val & (long)mask);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Line " + (lineno + 1) + ": invalid " + (Object)((Object)type) + " '" + imm + "'");
        }
    }

    private static int reg(String r) throws NumberFormatException {
        switch (r.charAt(0)) {
            case 'z': {
                return 0;
            }
            case 'a': {
                if (r.equals("at")) {
                    return 1;
                }
                return 4 + Integer.parseInt(r.substring(1));
            }
            case 'v': {
                return 2 + Integer.parseInt(r.substring(1));
            }
            case 't': {
                int i = Integer.parseInt(r.substring(1));
                if (i <= 7) {
                    return 8 + i;
                }
                return 24 + (i - 8);
            }
            case 's': {
                if (r.equals("sp")) {
                    return 29;
                }
                return 16 + Integer.parseInt(r.substring(1));
            }
            case 'k': {
                return 26 + Integer.parseInt(r.substring(1));
            }
            case 'g': {
                return 28;
            }
            case 'f': {
                return 30;
            }
            case 'r': {
                return 31;
            }
        }
        return Integer.parseInt(r);
    }

    private static Segment[] pass2(ArrayList<String> lines, int start_address, HashMap<String, Integer> sym) throws IOException {
        Segment[] seg;
        ParseException err = new ParseException();
        int addr = start_address;
        int cnt = 0;
        ArrayList<Segment> seglist = new ArrayList<Segment>();
        int pc = start_address >>> 2;
        for (int lineno = 0; lineno < lines.size(); ++lineno) {
            String line = lines.get(lineno);
            if (line == null) continue;
            if (line.toLowerCase().startsWith(".text ")) {
                if (cnt > 0) {
                    seglist.add(new Segment(pc, new int[cnt]));
                }
                cnt = 0;
                pc = ProgramAssembler.parseSegmentAddress(lineno, line.substring(line.indexOf(32) + 1)) >>> 2;
                continue;
            }
            ++cnt;
        }
        if (cnt > 0) {
            seglist.add(new Segment(pc, new int[cnt]));
        }
        if ((seg = new Segment[seglist.size()]).length == 0) {
            return seg;
        }
        for (int s = 0; s < seg.length; ++s) {
            seg[s] = (Segment)seglist.get(s);
            for (int s2 = 0; s2 < s; ++s2) {
                if (seg[s].start_pc >= seg[s2].start_pc + seg[s2].data.length || seg[s2].start_pc >= seg[s].start_pc + seg[s].data.length) continue;
                err.add("Assembly segment at " + ProgramAssembler.toHex(seg[s].start_pc * 4, 8) + ".." + ProgramAssembler.toHex((seg[s].start_pc + seg[s].data.length) * 4, 8) + " overlaps with segment at " + ProgramAssembler.toHex(seg[s2].start_pc * 4, 8) + ".." + ProgramAssembler.toHex((seg[s2].start_pc + seg[s2].data.length) * 4, 8));
            }
        }
        int cs = 0;
        cnt = 0;
        for (int lineno = 0; lineno < lines.size(); ++lineno) {
            String args;
            String line = lines.get(lineno);
            if (line == null) continue;
            int i = line.indexOf(32);
            String instr = i >= 0 ? line.substring(0, i) : line;
            String string = args = i >= 0 ? line.substring(i + 1) : "";
            if (instr.equalsIgnoreCase(".text")) {
                cs = -1;
                pc = ProgramAssembler.parseSegmentAddress(lineno, line.substring(line.indexOf(32) + 1)) >>> 2;
                addr = pc << 2;
                cnt = 0;
                for (int s = 0; s < seg.length; ++s) {
                    if (seg[s].start_pc != pc) continue;
                    cs = s;
                    break;
                }
                if (cs >= 0) continue;
                err.add("Line " + (lineno + 1) + ": internal error: bad segment");
                continue;
            }
            Command cmd = cmds.get(instr.toLowerCase());
            if (cmd == null) {
                err.add("Line " + (lineno + 1) + ": unrecognized instruction: '" + instr + "'");
                continue;
            }
            if (cs < 0) continue;
            try {
                seg[cs].data[cnt++] = cmd.encode(lineno, addr, args, sym);
            }
            catch (ParseException e) {
                err.add(e);
            }
            addr += 4;
        }
        if (err.getCount() > 0) {
            throw err;
        }
        return seg;
    }

    private static Segment[] assemble(ArrayList<String> src_lines, int start_address, ArrayList<Integer> addr_map) throws IOException {
        ArrayList<String> lines = ProgramAssembler.normalize(src_lines);
        HashMap<String, Integer> sym = ProgramAssembler.pass1(lines, start_address, addr_map);
        return ProgramAssembler.pass2(lines, start_address, sym);
    }

    private static String disassemble(int[] code, int start_addr) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < code.length; ++i) {
            Command cmd;
            int instr = code[i];
            int op = instr >> 26 & 0x3F;
            if (op == 0) {
                int f = instr & 0x3F;
                cmd = fcodes.get(new Integer(f));
            } else if (op == 1) {
                int subop = instr >> 16 & 0x1F;
                cmd = socodes.get(new Integer(subop));
            } else {
                cmd = opcodes.get(new Integer(op));
            }
            if (cmd == null) {
                throw new ParseException("Instruction " + (i + 1) + " unrecognized: " + ProgramAssembler.toHex(instr, 8));
            }
            buf.append(cmd.decode(start_addr + 4 * i, instr) + "\n");
        }
        return buf.toString();
    }

    static String disassemble(int instr, int addr) {
        Command cmd;
        int op = instr >> 26 & 0x3F;
        if (op == 0) {
            int f = instr & 0x3F;
            cmd = fcodes.get(new Integer(f));
        } else if (op == 1) {
            int subop = instr >> 16 & 0x1F;
            cmd = socodes.get(new Integer(subop));
        } else {
            cmd = opcodes.get(new Integer(op));
        }
        if (cmd == null) {
            cmd = opcodes.get(new Integer(-1));
        }
        return cmd.decode(addr, instr);
    }

    static {
        new Word(".word", -1);
        new Nop("nop", 0);
        new J("j", 2);
        new J("jal", 3);
        new Br("beq", 4);
        new Br("bne", 5);
        new Bz("blez", 6);
        new Bz("bgtz", 7);
        new RegImm("bltz", 0);
        new RegImm("bgez", 1);
        new ArithImm("addiu", 9, true);
        new ArithImm("slti", 10, true);
        new ArithImm("sltiu", 11, true);
        new ArithImm("andi", 12, false);
        new ArithImm("ori", 13, false);
        new ArithImm("xori", 14, false);
        new Lui("lui", 15);
        new Mem("lw", 35);
        new Mem("lb", 32);
        new Mem("lbu", 36);
        new Mem("sw", 43);
        new Mem("sb", 40);
        new ArithReg("addu", 0, 33);
        new ArithReg("subu", 0, 35);
        new ArithReg("and", 0, 36);
        new ArithReg("or", 0, 37);
        new ArithReg("xor", 0, 38);
        new ArithReg("nor", 0, 39);
        new ArithReg("slt", 0, 42);
        new ArithReg("sltu", 0, 43);
        new ArithReg("movz", 0, 10);
        new ArithReg("movn", 0, 11);
        new ShiftConstant("sll", 0, 0);
        new ShiftConstant("srl", 0, 2);
        new ShiftConstant("sra", 0, 3);
        new ShiftVariable("sllv", 0, 4);
        new ShiftVariable("srlv", 0, 6);
        new ShiftVariable("srav", 0, 7);
        new Jr("jr", 0, 8);
        new Jalr("jalr", 0, 9);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegImm
    extends Command {
        int subop;

        RegImm(String name, int subop) {
            super(name, 1);
            this.subop = subop;
            socodes.put(new Integer(subop), this);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_regimm.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S, offset or label");
            }
            int offset = ProgramAssembler.resolve(lineno, m.group(2), addr, sym, Type.SIGNED_RELATIVE, 18);
            if ((offset & 3) != 0) {
                throw new ParseException("Line " + (lineno + 1) + ": mis-aligned offset in '" + this.name + "'");
            }
            try {
                int src = ProgramAssembler.reg(m.group(1));
                int imm = offset >> 2 & 0xFFFF;
                if ((this.subop & 0x1F) != this.subop) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid sub-operation: $" + this.subop);
                }
                if ((src & 0x1F) != src) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid source register: $" + src);
                }
                return 0x4000000 | src << 21 | this.subop << 16 | imm;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Line " + (lineno + 1) + ": invalid arguments to '" + this.name + "': " + e.getMessage());
            }
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rS(instr) + ", " + this.sImm(instr << 2);
        }

        String rS(int instr) {
            return "$" + (instr >> 21 & 0x1F);
        }

        String sImm(int instr) {
            return ProgramAssembler.toHex(instr & 0xFFFF, 4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jalr
    extends RType {
        Jalr(String name, int zero, int f) {
            super(name, zero, f);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_jalr.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S");
            }
            boolean haveOpt = m.group(2) != null;
            String rd = haveOpt ? m.group(1) : "31";
            String rs = m.group(haveOpt ? 2 : 1);
            return this.encode(rd, rs, "0", 0, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            if ("31".equals(this.rD(instr))) {
                return this.name + " " + this.rS(instr);
            }
            return this.name + " " + this.rD(instr) + ", " + this.rS(instr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jr
    extends RType {
        Jr(String name, int zero, int f) {
            super(name, zero, f);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_jr.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S");
            }
            return this.encode("0", m.group(1), "0", 0, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rS(instr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShiftVariable
    extends RType {
        ShiftVariable(String name, int zero, int f) {
            super(name, zero, f);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_shift_v.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $T, $S");
            }
            return this.encode(m.group(1), m.group(3), m.group(2), 0, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.rT(instr) + ", " + this.rS(instr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShiftConstant
    extends RType {
        ShiftConstant(String name, int zero, int f) {
            super(name, zero, f);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_shift_c.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $T, sa");
            }
            int sa = ProgramAssembler.resolve(lineno, m.group(3), addr, sym, Type.UNSIGNED_ABSOLUTE, 5);
            return this.encode(m.group(1), "0", m.group(2), sa, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.rT(instr) + ", " + this.sSa(instr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArithReg
    extends RType {
        ArithReg(String name, int zero, int f) {
            super(name, zero, f);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_arith_reg.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $S, $T");
            }
            return this.encode(m.group(1), m.group(2), m.group(3), 0, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.rS(instr) + ", " + this.rT(instr);
        }
    }

    private static abstract class RType
    extends Command {
        int f;

        RType(String name, int zero, int f) {
            super(name, 0);
            this.f = f;
            fcodes.put(new Integer(f), this);
        }

        int encode(String rd, String rs, String rt, int sa, int lineno) throws IOException {
            try {
                int dest = ProgramAssembler.reg(rd);
                int src = ProgramAssembler.reg(rs);
                int trg = ProgramAssembler.reg(rt);
                if ((dest & 0x1F) != dest) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid destination register: $" + dest);
                }
                if ((src & 0x1F) != src) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid source1 register: $" + src);
                }
                if ((trg & 0x1F) != trg) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid source2 register: $" + trg);
                }
                if ((sa & 0x1F) != sa) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid shift amount: " + sa);
                }
                return this.opcode << 26 | src << 21 | trg << 16 | dest << 11 | sa << 6 | this.f;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Line " + (lineno + 1) + ": invalid arguments to '" + this.name + "': " + e.getMessage());
            }
        }

        String rD(int instr) {
            return "$" + (instr >> 11 & 0x1F);
        }

        String rS(int instr) {
            return "$" + (instr >> 21 & 0x1F);
        }

        String rT(int instr) {
            return "$" + (instr >> 16 & 0x1F);
        }

        String sSa(int instr) {
            return "" + (instr >> 6 & 0x1F);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class J
    extends Command {
        J(String name, int op) {
            super(name, op);
            opcodes.put(new Integer(op), this);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_j0.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects address or label");
            }
            int absaddr = ProgramAssembler.resolve(lineno, m.group(1), addr, sym, Type.UNSIGNED_ABSOLUTE, 32);
            if ((absaddr & 3) != 0) {
                throw new ParseException("Line " + (lineno + 1) + ": mis-aligned address in '" + this.name + "'");
            }
            if ((absaddr & 0xF0000000) != (addr + 4 & 0xF0000000)) {
                throw new ParseException("Line " + (lineno + 1) + ": overflow in address in '" + this.name + "': can't jump from " + ProgramAssembler.toHex(addr, 8) + " to " + ProgramAssembler.toHex(absaddr, 8));
            }
            return this.opcode << 26 | absaddr >> 2 & 0x3FFFFFF;
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + ProgramAssembler.toHex(addr + 4 & 0xF0000000 | (instr & 0x3FFFFFF) << 2, 8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bz
    extends IType {
        Bz(String name, int op) {
            super(name, op);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_bz.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S, offset or label");
            }
            int offset = ProgramAssembler.resolve(lineno, m.group(2), addr, sym, Type.SIGNED_RELATIVE, 18);
            if ((offset & 3) != 0) {
                throw new ParseException("Line " + (lineno + 1) + ": mis-aligned offset in '" + this.name + "'");
            }
            return this.encode("0", m.group(1), offset >> 2, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rS(instr) + ", " + this.sImm(instr << 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Br
    extends IType {
        Br(String name, int op) {
            super(name, op);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_br.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $S, $T, offset or label");
            }
            int offset = ProgramAssembler.resolve(lineno, m.group(3), addr, sym, Type.SIGNED_RELATIVE, 18);
            if ((offset & 3) != 0) {
                throw new ParseException("Line " + (lineno + 1) + ": mis-aligned offset in '" + this.name + "'");
            }
            return this.encode(m.group(2), m.group(1), offset >> 2, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rS(instr) + ", " + this.rD(instr) + ", " + this.sImm(instr << 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mem
    extends IType {
        Mem(String name, int op) {
            super(name, op);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_mem.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, signed_imm($S)");
            }
            int imm = ProgramAssembler.resolve(lineno, m.group(2), addr, sym, Type.SIGNED_ABSOLUTE, 16);
            return this.encode(m.group(1), m.group(3), imm, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.sImm(instr) + "(" + this.rS(instr) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Lui
    extends IType {
        Lui(String name, int op) {
            super(name, op);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_lui.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, imm");
            }
            int imm = ProgramAssembler.resolve(lineno, m.group(2), addr, sym, Type.ANY_ABSOLUTE, 16);
            return this.encode(m.group(1), "0", imm, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.sImm(instr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArithImm
    extends IType {
        Type itype;

        ArithImm(String name, int op, boolean signed) {
            super(name, op);
            this.itype = signed ? Type.SIGNED_ABSOLUTE : Type.UNSIGNED_ABSOLUTE;
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_arith_imm.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects $D, $S, " + (Object)((Object)this.itype));
            }
            int imm = ProgramAssembler.resolve(lineno, m.group(3), addr, sym, this.itype, 16);
            return this.encode(m.group(1), m.group(2), imm, lineno);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + this.rD(instr) + ", " + this.rS(instr) + ", " + this.sImm(instr);
        }
    }

    private static abstract class IType
    extends Command {
        IType(String name, int op) {
            super(name, op);
            opcodes.put(new Integer(op), this);
        }

        int encode(String rd, String rs, int imm, int lineno) throws IOException {
            try {
                int dest = ProgramAssembler.reg(rd);
                int src = ProgramAssembler.reg(rs);
                imm &= 0xFFFF;
                if ((dest & 0x1F) != dest) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid destination register: $" + dest);
                }
                if ((src & 0x1F) != src) {
                    throw new ParseException("Line " + (lineno + 1) + ": invalid source register: $" + src);
                }
                return this.opcode << 26 | src << 21 | dest << 16 | imm;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Line " + (lineno + 1) + ": invalid arguments to '" + this.name + "': " + e.getMessage());
            }
        }

        String rD(int instr) {
            return "$" + (instr >> 16 & 0x1F);
        }

        String rS(int instr) {
            return "$" + (instr >> 21 & 0x1F);
        }

        String sImm(int instr) {
            return ProgramAssembler.toHex(instr & 0xFFFF, 4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Word
    extends Command {
        Word(String name, int op) {
            super(name, op);
            opcodes.put(new Integer(op), this);
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> sym) throws IOException {
            Matcher m = pat_word.matcher(args);
            if (!m.matches()) {
                throw new ParseException("Line " + (lineno + 1) + ": '" + this.name + "' expects integer argument");
            }
            int word = ProgramAssembler.resolve(lineno, m.group(1), addr, sym, Type.ANY_ABSOLUTE, 32);
            return word;
        }

        @Override
        String decode(int addr, int instr) {
            return this.name + " " + ProgramAssembler.toHex(instr, 8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Nop
    extends Command {
        Nop(String name, int op) {
            super(name, op);
        }

        @Override
        String decode(int addr, int instr) {
            return this.name;
        }

        @Override
        int encode(int lineno, int addr, String args, HashMap<String, Integer> hashmap) throws IOException {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Command {
        String name;
        int opcode;

        Command(String name, int op) {
            this.name = name;
            this.opcode = op;
            cmds.put(name, this);
        }

        abstract String decode(int var1, int var2);

        abstract int encode(int var1, int var2, String var3, HashMap<String, Integer> var4) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SIGNED_RELATIVE,
        SIGNED_ABSOLUTE,
        UNSIGNED_ABSOLUTE,
        ANY_ABSOLUTE;

    }

    static class ParseException
    extends IOException {
        private static final long serialVersionUID = 4648870901015801834L;
        StringBuffer msg = new StringBuffer();
        int count = 0;

        public ParseException() {
        }

        public ParseException(String m) {
            this();
            this.add(m);
        }

        public void add(String m) {
            this.msg.append("\n");
            this.msg.append(m);
            ++this.count;
        }

        public void add(ParseException e) {
            this.msg.append(e.msg.toString());
            this.count += e.getCount();
        }

        public String getMessage() {
            return "Assembling MIPS instructions: " + this.count + (this.count == 1 ? " error:" : " errors:") + this.msg.toString();
        }

        public int getCount() {
            return this.count;
        }
    }

    static class Listing
    implements Cloneable {
        private String src = "";
        private Segment[] seg = new Segment[0];
        private ProgramState state;
        private ArrayList<String> src_lines = new ArrayList();
        private ArrayList<Integer> addr_map = new ArrayList();

        public Listing() {
        }

        public Listing(String value) throws IOException {
            this.setSource(value);
        }

        public void setListener(ProgramState state) {
            this.state = state;
        }

        public void load(File file) throws IOException {
            String s = ProgramAssembler.readFully(file);
            this.setSource(s);
        }

        public ProgramState getState() {
            return this.state;
        }

        public String getSource() {
            return this.src;
        }

        public int getLineCount() {
            return this.src_lines.size();
        }

        public String getLine(int index) {
            return this.src_lines.get(index);
        }

        public int getAddressOf(int index) {
            Integer i = this.addr_map.get(index);
            if (i == null) {
                return -1;
            }
            return i;
        }

        public void setSource(String s) throws IOException {
            ArrayList sl = ProgramAssembler.splitLines(s);
            ArrayList am = new ArrayList();
            this.seg = ProgramAssembler.assemble(sl, 0, am);
            this.src = s;
            this.addr_map = am;
            this.src_lines = sl;
        }

        public boolean isEmpty() {
            return this.seg.length == 0;
        }

        int instr(int i) {
            Segment s = this.segmentOf(i);
            if (s != null) {
                return s.data[i - s.start_pc];
            }
            return 0;
        }

        Segment segmentOf(int i) {
            for (int s = 0; s < this.seg.length; ++s) {
                if (i < this.seg[s].start_pc || i >= this.seg[s].start_pc + this.seg[s].data.length) continue;
                return this.seg[s];
            }
            return null;
        }

        public Listing clone() {
            try {
                return (Listing)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class Segment
    implements Cloneable {
        public int start_pc;
        public int[] data;

        public Segment(int pc, int[] d) {
            this.start_pc = pc;
            this.data = d;
        }
    }
}

