#ifndef _HUST___PARSER_HPP
#define _HUST___PARSER_HPP 1

#include <reflected_impl.hpp>
#include <list>
#include <string>
#include <iomanip>

#include <rlib/stdio.hpp>
#include <rlib/terminal.hpp>

using namespace rlib::terminal;

class parser
{
private:
    static void help_msg()
    {
        std::string msg = R"_STR_(
rfaketerm 0.3.1 HUST_xxxx special edition

>>> Usage: <Command> [args ...]

>>> Command List:

FuncName [Argument ...] -> ReturnValue # Instructions

help -> null # Show this message.
exit -> int # Exit.
load [string file_name] -> null # Load data from json file.
save [string file_name] -> null # Save data to json file.
clear -> null # Clear data in buffer.

new_person -> string # `new` a person, with a random-generated id.
new_person_at [string id_to_assign] -> string # `new` a person, with a specified id.
rm_person [string person_id] -> string # remove the person specified by id.
get [string person_id] -> null # Show all information about the person.
ls -> null # List all person_id.

add [string what, string person_id, string to_add_id] -> string # add a friend/follower/following.
rm [string what, string person_id, string to_remove_id] -> string # remove a friend/follower/following.
common [string what, string person1_id, string person2_id] -> null # get common friend/follower/following of two person.
indirect [string what, string person_id] -> null # get 2-degree(indirect) friend/follower/following of a person.)_STR_";
        rlib::println(msg);
    }

public:
    static void parse(const std::vector<std::string> &to_parse)
    {
        if (to_parse.empty())
            return;
        rlib::print(std::boolalpha);

#define AREA_BEGIN if(to_parse.begin()->empty()) {}
#define IFCMD(str) else if(*to_parse.begin() == str)
#define AREA_END else

#define WANT_ARG(n) if(to_parse.size() != n+1) {throw std::runtime_error(rlib::format_string("{} arguments wanted but {} provided.", n, to_parse.size()-1));}
#define STRING_ARG(n) to_parse[n]
#define SIZE_ARG(n) std::stoul(to_parse[n])
#define INT_ARG(n) std::stoi(to_parse[n])
#define HAVE_RETURN_VALUE auto ret =
#define PRINT_RETURN_VALUE rlib::println(ret);

        AREA_BEGIN
//__ccgen_managed_begin__

//Code generated by ccgen.py below. Do not edit them by hand.
//__ccgen_debug__: `ret name(args)` is `null save(string fname)`
    IFCMD("save") {
        WANT_ARG(1)
        impl.save(STRING_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null load(string fname)`
    IFCMD("load") {
        WANT_ARG(1)
        impl.load(STRING_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null clear()`
    IFCMD("clear") {
        WANT_ARG(0)
        impl.clear();
    }
//__ccgen_debug__: `ret name(args)` is `string new_person()`
    IFCMD("new_person") {
        WANT_ARG(0)
        HAVE_RETURN_VALUE
        impl.new_person();
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `string new_person_at(string id_to_assign)`
    IFCMD("new_person_at") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.new_person_at(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `string rm_person(string person_id)`
    IFCMD("rm_person") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.rm_person(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `null get(string person_id)`
    IFCMD("get") {
        WANT_ARG(1)
        impl.get(STRING_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null ls()`
    IFCMD("ls") {
        WANT_ARG(0)
        impl.ls();
    }
//__ccgen_debug__: `ret name(args)` is `string add(string what, string person_id, string to_add_id)`
    IFCMD("add") {
        WANT_ARG(3)
        HAVE_RETURN_VALUE
        impl.add(STRING_ARG(1), STRING_ARG(2), STRING_ARG(3));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `string rm(string what, string person_id, string to_remove_id)`
    IFCMD("rm") {
        WANT_ARG(3)
        HAVE_RETURN_VALUE
        impl.rm(STRING_ARG(1), STRING_ARG(2), STRING_ARG(3));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `null common(string what, string person1_id, string person2_id)`
    IFCMD("common") {
        WANT_ARG(3)
        impl.common(STRING_ARG(1), STRING_ARG(2), STRING_ARG(3));
    }
//__ccgen_debug__: `ret name(args)` is `null indirect(string what, string person_id)`
    IFCMD("indirect") {
        WANT_ARG(2)
        impl.indirect(STRING_ARG(1), STRING_ARG(2));
    }

    IFCMD("exit") {
        rlib::println("bye~");
        ::std::exit(0);
    }
    IFCMD("help") {
        help_msg();
    }
//impl.debug();
//Code generated by ccgen.py above. Do not edit them by hand.

//__ccgen_managed_end__
        AREA_END
        {
            throw std::invalid_argument("Invalid argument. Try to type `help` to get helped.");
        }


    }
};

#endif //_HUST___PARSER_HPP
