%{

#include <string>
#include <rlib.min.hpp>
#include <cassert>
#include <cstdlib>

extern int yylex();
extern int yyparse();

typedef struct yy_buffer_state * YY_BUFFER_STATE;
extern YY_BUFFER_STATE yy_scan_string(const char * str);
void yyerror(int64_t *result, std::string s);

static uint32_t skipped = 0;
%}

%union {
    int64_t ival;
}

%token<ival> T_INT
%left T_OR
%left T_AND
%left T_EQ T_NE
%left T_GE T_LE T_GT T_LT
%right '!'

%type<ival> expr

%start entry

%parse-param {int64_t *result}

%%
entry:                          {*result = 0;}
      | expr                    {*result = $1;}
;

expr: T_INT                     { $$ = $1; }
      | expr T_AND expr          { $$ = ($1 && $3); if(!$1) skipped++; }
      | expr T_OR expr           { $$ = ($1 || $3); if($1) skipped++; }
      | expr T_EQ expr           { $$ = ($1 == $3); }
      | expr T_NE expr           { $$ = ($1 != $3); }
      | expr T_GE expr           { $$ = ($1 >= $3); }
      | expr T_LE expr           { $$ = ($1 <= $3); }
      | expr T_GT expr           { $$ = ($1 >  $3); }
      | expr T_LT expr           { $$ = ($1 <  $3); }
      | '(' expr ')'            { $$ = $2; }
      | '!' expr                { $$ = ! $2; }
;

%%

#include <stdexcept>

auto parse_one(std::string expr) {
    skipped = 0;
    yy_scan_string(expr.c_str());
    int64_t result;
    assert(0 == yyparse(&result));
    return std::make_pair((bool)result, skipped);
}

int main() {
    rlib::print(std::boolalpha);
    while(true) {
        auto result = parse_one(rlib::scanln());
        if(std::cin.eof()) break;
        rlib::println("Output:", result.first, ',', result.second);
    }
    return 0;
}

void yyerror(int64_t *result, std::string msg) {
    throw std::runtime_error(std::string("Parse error:") + msg);
}

