#include <windows.h>
#include <tlhelp32.h>

#include <winps.hpp>
#include <cassert>
#include <rlib/scope_guard.hpp>

std::list<std::string> win32_ps() {
  // Take a snapshot of all processes in the system.
  auto hProcessSnap = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
  assert(hProcessSnap != INVALID_HANDLE_VALUE);
  rlib_defer([&]{CloseHandle(hProcessSnap);});

  PROCESSENTRY32 pe32;
  pe32.dwSize = sizeof(PROCESSENTRY32);

  assert(Process32First(hProcessSnap, &pe32));

  std::list<std::string> proc_names;
  do {
    proc_names.emplace_back(pe32.szExeFile);
  } while( Process32Next( hProcessSnap, &pe32 ) );

  return proc_names;
}

