﻿using System;

namespace FleetAGC.Activities.Util
{
    class Program
    {
        static void testcase(string expr, int answer)
        {
            var res = BasicExprParser.execute(expr);
            if (res.type != BasicExprParser.RuntimeType.INT)
                throw new Exception($"Testcase `{expr}` failed. expecting INT, returned `{res.type}`");
            if (res.valueInt != answer)
                throw new Exception($"Testcase `{expr}` failed. expecting `{answer}`, returned `{res.valueInt}`");
        }
        static void testcase(string expr, string answer)
        {
             var res = BasicExprParser.execute(expr);
             if (res.type != BasicExprParser.RuntimeType.STRING)
                 throw new Exception($"Testcase `{expr}` failed. expecting STRING, returned `{res.type}`");
             if (res.valueString != answer)
                 throw new Exception($"Testcase `{expr}` failed. expecting `'{answer}'`, returned `'{res.valueString}'`");
        }
        static void Main(string[] args)
        {
            testcase("6+4*2+10*(1+2+3+4)+5", 119);
            testcase("strlen(\"hello\") + 1", 6);
            testcase("(((((1)+2)*(3*(((4)))+1)+(5)))+(1))", 45);
            testcase("\"AB\" + strrepeat(\"C\", 10) + \"D\"", "ABCCCCCCCCCCD");
            testcase("\"hello\" + \"world\" +     strrepeat(\"y\", (1+(2*(2-1)))   +strlen(\"f\")*3)", "helloworldyyyyyy");
        }
    }
}