using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;
using System.Text;

namespace FleetAGC.Activities.Util
{
    public class BasicExprBuiltins
    {
        private static int builtin_strlen(string arg) => arg.Length;

        private static string builtin_strrepeat(string arg, int times) => new StringBuilder().Insert(0, arg, times).ToString();

        private static int builtin_stoi(string arg) => int.Parse(arg);

        private static string builtin_itos(int arg) => arg.ToString();
        
        //////////////////////////////// End of builtin functions ////////////////////////////////
        public static BasicExprParser.EvaluationResultType evaluate(string funcname, List<BasicExprParser.EvaluationResultType> args)
        {
            var methodInfo = typeof(BasicExprBuiltins).GetMethod("builtin_" + funcname, BindingFlags.NonPublic | BindingFlags.Static);
            if (methodInfo == null)
                throw new SyntaxErrorException($"Invalid syntax: can not find `static private builtin_{funcname}` in class BasicExprBuiltins. The builtin function doesn't exist. ");
            object[] args_to_forward = new object[methodInfo.GetParameters().Length];
            for (var i = 0; i < args_to_forward.Length; ++i)
            {
                var requiredType = methodInfo.GetParameters()[i].ParameterType.FullName;
                switch (requiredType)
                {
                    case "System.String":
                        if(args[i].type != BasicExprParser.RuntimeType.STRING) 
                            throw new ArgumentException($"TypeChecking Error: expecting `string` at function argument, got {args[i].type}. at `{args[i].originalText}`");
                        args_to_forward[i] = args[i].valueString;
                        break;
                    case "System.Int32":
                        if(args[i].type != BasicExprParser.RuntimeType.INT) 
                            throw new ArgumentException($"TypeChecking Error: expecting `int` at function argument, got {args[i].type}. at `{args[i].originalText}`");
                        args_to_forward[i] = args[i].valueInt;
                        break;
                    default:
                        throw new InvalidProgramException("builtin function can only accept supported type: int or string.");
                }
            }
            var call_result = methodInfo.Invoke(null, args_to_forward);
            var evaluation_result = new BasicExprParser.EvaluationResultType();
            switch (methodInfo.ReturnType.FullName)
            {
                case "System.Int32":
                    evaluation_result.type = BasicExprParser.RuntimeType.INT;
                    evaluation_result.valueInt = (int)call_result;
                    break;
                case "System.String":
                    evaluation_result.type = BasicExprParser.RuntimeType.STRING;
                    evaluation_result.valueString = (string)call_result;
                    break;      
                default:
                    throw new InvalidProgramException("builtin function can only return supported type: int or string.");
            }
            return evaluation_result;
        }
    }
}
