package main

import (
	"io/ioutil"
	"log"
	"os"
	"reflect"
	"strings"
)

func Filter(arr interface{}, cond func(interface{}) bool) interface{} {
	contentType := reflect.TypeOf(arr)
	contentValue := reflect.ValueOf(arr)

	newContent := reflect.MakeSlice(contentType, 0, 0)
	for i := 0; i < contentValue.Len(); i++ {
		if content := contentValue.Index(i); cond(content.Interface()) {
			newContent = reflect.Append(newContent, content)
		}
	}
	return newContent.Interface()
}

func logErrorIfAny(err error, title string) {
	if err != nil {
		log.Println("[Error] on " + title + ": " + err.Error())
	}
}
func panicErrorIfAny(err error, title string) {
	if err != nil {
		panic("[Error] on " + title + ": " + err.Error())
	}
}

func stringToTempFile(s, pattern string) (filename string, err error) {
	tmpfile, err := ioutil.TempFile("", pattern)
	if err != nil {
		return
	}

	_, err = tmpfile.Write([]byte(s))
	if err != nil {
		return
	}
	err = tmpfile.Close()
	if err != nil {
		return
	}
	return tmpfile.Name(), nil
}

func assertStringNotEmpty(s, msg string) {
	if s == "" {
		panic(msg)
	}
}

// Example:
// PkgCis_SdkV2 => Cis.SdkV2
// PkgMicrosoft_Azure_Management_Cdn_Fluent => Microsoft.Azure.Management.Cdn.Fluent
// On error, returns empty string.
func guessPkgNameFromVarName(varName string) string {
	if len(varName) <= 3 || varName[:3] != "Pkg" {
		return ""
	}
	return strings.ReplaceAll(varName[3:], "_", ".")
}

func pathIsDir(path string) bool {
	_, err := os.Stat(path)
	if err == nil { return true }
	if os.IsNotExist(err) { return false }
	return false
}

// On error, return empty string
func targetFrameworkVersion2TargetFramework(oldVersion string) string {
	if oldVersion[:1] != "v" {
		return ""
	}
	return "net" + strings.ReplaceAll(oldVersion[1:], ".", "")
}

func depsDeduplicate(deps []dependencyItem) (resultDeps []dependencyItem) {
	hashset := make(map[string]bool)
	for _, dep := range deps {
		niddle := dep.envName + dep.targetNetVer
		if _, ok := hashset[niddle]; !ok {
			hashset[niddle] = true
			resultDeps = append(resultDeps, dep)
		}
	}
	return
}
