package main

import (
	"flag"
	"fmt"
	"log"
	"os"
)

// Some options here. Would be improved in beta release.
const DEDUCT_PKGNAME_FROM_VARNAME = true
const USE_PROJECT_NETVER_INSTEAD_OF_HINTPATH_NETVER = false
const OPENXT_VERSION = "1.0.0b"

func main() {
	log.Println("OpenXT version " + OPENXT_VERSION)

	nugetConfigPath := "/home/recolic/tmp/test.nuget.config" // warning: not supported yet
	projectDir := flag.String("project-dir", "", "Path to the CoreXT/OpenXT project. ")
	localRepoDir := flag.String("local-repo-dir", "", "Path to local nuget repo. (known as CxCache in CoreXT)")
	binDir := flag.String("bin-dir", "", "Path for output build. (TODO: remove in the future)")
	shell := flag.String("shell", "bash", "Shell for the output env variables")

	// Trick
	os.Args = os.Args[1:]
	flag.Parse()

	assertStringNotEmpty(*projectDir, "`--project-dir` must be set")
	assertStringNotEmpty(*localRepoDir, "`--local-repo-dir` must be set")
	deps := ScanForDependencies(*projectDir)

	switch os.Args[0] {
	case "sync":
		SyncPackages(nugetConfigPath, *localRepoDir, deps)
	case "env":
		assertStringNotEmpty(*binDir, "`--bin-dir` must be set")

		envvar := GenerateCorextEnvvar(*localRepoDir, *binDir, deps)
		// log.Println() and println() writes to stderr, and fmt.Println() writes to stdout.
		fmt.Println(SerializeEnvvar(*shell, false, envvar))
	default:
		panic("Expected subcommand `sync` or `env`. ")
	}
}
