# Make your csproj compliance with .NET 5.0

.NET 5.0 is required to build .NET framework projects on Linux and MacOS, and it's also required 
by OpenXT on any platform. You have to modify your csproj to be compliance with .NET 5.0. 

> OpenXT would NOT solve any issue about dotNET 5.0 compliance. DO NOT create issue about this. 

**This article just contains my personal opinion. It doesn't come from CloudBuild/CoreXT/dotnet official team. Use it at your own risk!**

## Common issues in existing CoreXT projects

> Fixing issues in this section has no risk to existing users. 

|Rate of Error|ControlPlane|Azure-Deployment-Builder|
|---|---|---|
|Wrong Import Statement|60/1287|3/30|
|TargetFramework not set|91/217|28/28|

### Wrong Import statement

- Problem

It's required to have `<Import Project="$(ExtendedTargetsPath)\Microsoft.CSharp.targets" />` in CoreXT project. 
CoreXT rely on this statement to inject extra build targets. 

However, some projects are importing `$(MSBuildToolsPath)\Microsoft.CSharp.targets`. This is not necessary in
older version of dotNET, and causes double import error while using `Sdk="Microsoft.NET.Sdk"`. 

- Solution

Change `$(MSBuildToolsPath)\Microsoft.CSharp.targets` to `$(ExtendedTargetsPath)\Microsoft.CSharp.targets`. 

### TargetFramework not set

- Problem

> [What's the difference between TargetFrameworkVersion and TargetFramework](https://stackoverflow.com/questions/46778064/whats-the-difference-between-targetframework-and-runtimeframeworkversion)

Some projects only set `TargetFrameworkVerion` instead of `TargetFramework`. 
This practice is outdated and unreliable. Although OpenXT supports it, dotNET 5.0 would fail without `TargetFramework`. 

- Solution

Remove `<TargetFrameworkVersion>v4.7.2</TargetFrameworkVersion>`, and add 

```xml
    <TargetFramework>net472</TargetFramework>
    <GenerateTargetFrameworkAttribute>false</GenerateTargetFrameworkAttribute>
```

## Common outdated practice in existing CoreXT projects

> Fixing issues in this section may affect existing users. 

|Rate of Issue|ControlPlane|Azure-Deployment-Builder|
|---|---|---|
|Not using Microsoft.NET.Sdk|2151/2263|38/38|
|Compile Include statement|1252/2345|16/50|

### Not using Microsoft.NET.Sdk

- Problem

New dotnet projects are recommended to use `<Project Sdk="Microsoft.NET.Sdk" ...>` at the beginning of project, 
but many old projects are using `<Project ToolsVersion="xx.0" ...>`. This may cause dotnet 5.0 fails to build 
the project. 

TODO: `DefaultTargets="Build"` may fail the build. Test if it's ok for CoreXT without this statement. 

- Solution

Change `<Project ToolsVersion="xx.0" ...>` to `<Project Sdk="Microsoft.NET.Sdk" ...>`. 

### Compile Include statement

All `*.cs` files under project directory are automatically included in dotnet 5.0,
and extra `<Compile Include="xxxx.cs" />` causes build failure. 

- Solution

You must remove them or fail the compile. 
