# OpenXT

> Use Open Standards, Open Data, Open Source, and Open Innovation

A portable, simple, cross-platform, fast implementation of CoreXT. 

Download release at <https://drive.recolic.net/s/CbtmdPNo6dStX6W>. (Azure Pipeline artifact uploading is too hard to use)

## Dependency

> This is a naive new Go programmer. The coding style is bad and don't learn from it!

Build time: Go 

Runtime: dotnet > 5.0

## Build

```bash
go build .
```

## Usage

#### 1. Add MSCORP sources to your nuget.config on linux machine. 
   
To avoid the annoying login, goto `DevOps -> TopRightCorner -> Settings -> Personal Access Tokens`, 
then create a new token, select `All accessible organizations`, and allow permission `Packaging/read`. 
Save the token for future usage. 

Then use `dotnet nuget add` to add all sources your need. This is an example: 

```bash
dotnet nuget add source "https://msazure.pkgs.visualstudio.com/_packaging/Official/nuget/v3/index.json" --name MSAzure --username bensl --password "xbwejuparq4ighqs_Your_Token_Here_qshql2uy3woi73ew6iq" --store-password-in-clear-text
```

For convenience, this is some common nuget source for O365 developers: 

```xml
<packageSources>
  <add key="nuget.org" value="https://api.nuget.org/v3/index.json" protocolVersion="3" />
  <add key="MSAzure" value="https://msazure.pkgs.visualstudio.com/_packaging/Official/nuget/v3/index.json" />
  <add key="Official@Local" value="https://msazure.pkgs.visualstudio.com/_packaging/Official%40Local/nuget/v3/index.json" />
  <add key="O365Core" value="https://o365exchange.pkgs.visualstudio.com/_packaging/Common/nuget/v3/index.json" />
  <add key="M365FleetAGC" value="https://o365exchange.pkgs.visualstudio.com/959adb23-f323-4d52-8203-ff34e5cbeefa/_packaging/M365FleetAGC/nuget/v3/index.json" />
  <add key="Skype" value="https://skype.pkgs.visualstudio.com/DefaultCollection/_packaging/csc/nuget/v3/index.json" />
</packageSources>
```

Good. Check your `~/.nuget/NuGet/NuGet.Config` to make sure nothing goes wrong. 

#### 2. Use OpenXT to init CxCache

`CxCache` is a bad name, let's name it as `Local Nuget Repo`. 

Init or sync your `local nuget repo` with the following command: 

```bash
openxt sync --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache"
```

> It's OK for multiple projects to share one local-repo-dir. 

> It's OK to set --project-dir to a small sub-project, instead of the huge ControlPlane. 

#### 3. Use OpenXT to develop or build your project

> There's outdated syntax in many csproj files, which prevents your project to build in .NET 5. 
> This IS NOT a OpenXT issue, read [doc/csproj-compliance-net5.md](doc/csproj-compliance-net5.md) for more detail. 

OpenXT currently supports bash, fish, and ~~powershell~~. You may run the following command to enable your
shell session to work on CoreXT projects: 

```bash
# bash-only
openxt env --shell bash --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache" | source
rider xxx.sln
```

```bash
# fish-only
openxt env --shell fish --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache" | source
dotnet build
```

## Performance

In our Azure-Deployment-Builder repo, using Windows Bare-Metal (1065G7, 16G-DDR4-3733MHz, NVME SSD) and 
Linux Bare-Metal (W-2123, 32G-DDR4-2666MHz, SATA SSD). Windows defender has been destroyed on the CoreXT machine. 

|Time|CoreXT (Windows Bare-Metal)|OpenXT (Linux Bare-Metal)|
|:---|:---:|:---:|
|First launch (init)|10.83min (maximum hand speed)|17.85min|
|Subsequent launch|1.435s(cache) - 20.998s(no_cache)|31.86ms|

## TODO

[DONE!] 1. Use the framework version in HintPath to download package. (bugfix)

2. deps de-duplicate

3. Parallelize `openxt sync` with multiple fake environment. 

4. possible coreXT design issue: If `myProject/subproject1` requires pkgA:net472, 
   and `myProject/subproject2` requires pkgA:net451. And pkgA:1.0.1 only provides net451, 
   and pkgA:1.0.2 only provides net472, it booms.

## FAQ

- How do I build ControlPlane with OpenXT?

OpenXT is not a build management tool, and we use dotnet 5.0 to build projects. 
One software should do one thing, and there would be another tool to use `dotnet build` to build a 
large directory like ControlPlane. 

It's easier to only build the small project that you're working on. 

- OpenXT-built CIS workflow fails to run on CIS beta site.

CIS isn't fully happy with .NET 5. You should do the following manually: 

1. Make sure you have copied *.xaml to the output directory. 
2. You must delete all *.pdb file from the output directory. (or build a release/retail version instead of debug version)


## Bug report

If you have no permission to submit a issue, feel free to email bensl@microsoft.com to report a bug. 
Please include the keyword `__recolic_filter_whitelist_pproj` in your email **content** (not subject) to make sure 
your email appears on the top of my mailbox. 
