#!/bin/bash
# workdir should be project root dir. 
# build_host must be linux, guest can be anything. 

version=$(grep 'const OPENXT_VERSION' main.go | sed 's/^[^"]*"//g' | sed 's/".*$//g')

[[ "$version" = "" ]] && echo "Unable to get openxt version. aborting..." && exit 2

function build () {
    os="$1"
    arch="$2"
    echo "Building OpenXT $version for $os:$arch ..."

    [[ "$os" = "windows" ]] && bin_tail=".exe" || bin_tail=""
    rm -rf bin/

    GOOS="$os" GOARCH="$arch" go build -o "bin/openxt$bin_tail" . &&
    GOOS="$os" GOARCH="$arch" go build -o "bin/csproj-to-5$bin_tail" tools/csproj-to-5/main.go &&
    tar cvzf "openxt-$version-$os-$arch.tar.gz" bin

    return $?
}

# Just add architectures you want. Run `go tool dist list` for available architectures. 
build linux amd64
build linux 386
build linux arm
build linux arm64
build freebsd amd64
build openbsd amd64
build darwin amd64
build windows amd64
build windows arm
build windows 386

build linux mips
build linux mips64
build linux mipsle
build linux mips64le
build linux riscv64

