# OpenXT

> This is a naive new Go programmer. The coding style is bad and don't learn from it!

A portable, simple, multi-platform, light implementation of CoreXT. 

## Dependency

Build time: Go 

Runtime: dotnet > 5.0

## Build

```bash
go build .
```

## Usage

#### 1. Add MSCORP sources to your nuget.config on linux machine. 
   
To avoid the annoying login, goto `DevOps -> TopRightCorner -> Settings -> Personal Access Tokens`, 
then create a new token, select `All accessible organizations`, and allow permission `Packaging/read`. 
Save the token for future usage. 

Then use `dotnet nuget add` to add all sources your need. This is an example: 

> Adding sources in this way could avoid annoying login prompt. 

```bash
dotnet nuget add source "https://msazure.pkgs.visualstudio.com/_packaging/Official/nuget/v3/index.json" --name CiUpstreamFeed --username bensl --password "xbwejuparq4ighqs_Your_Token_Here_qshql2uy3woi73ew6iq" --store-password-in-clear-text
```

For convenience, this is some common nuget source for O365 developers: 

```xml
<packageSources>
  <add key="nuget.org" value="https://api.nuget.org/v3/index.json" protocolVersion="3" />
  <add key="MSAzure" value="https://msazure.pkgs.visualstudio.com/_packaging/Official/nuget/v3/index.json" />
  <add key="Official@Local" value="https://msazure.pkgs.visualstudio.com/_packaging/Official%40Local/nuget/v3/index.json" />
  <add key="O365Core" value="https://o365exchange.pkgs.visualstudio.com/_packaging/Common/nuget/v3/index.json" />
  <add key="M365FleetAGC" value="https://o365exchange.pkgs.visualstudio.com/959adb23-f323-4d52-8203-ff34e5cbeefa/_packaging/M365FleetAGC/nuget/v3/index.json" />
  <add key="Skype" value="https://skype.pkgs.visualstudio.com/DefaultCollection/_packaging/csc/nuget/v3/index.json" />
</packageSources>
```

Good. Check your `~/.nuget/NuGet/NuGet.Config` to make sure nothing goes wrong. 

#### 2. Use OpenXT to init CxCache

`CxCache` is a bad name, let's name it as `Local Nuget Repo`. 

Init or sync your `local nuget repo` with the following command: 

```bash
openxt sync --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache"
```

> It's OK for multiple projects to share one local-repo-dir.

#### 3. Use OpenXT to develop or build your project

> There's outdated syntax in many csproj files, which prevents your project to build in .NET 5. 
> This IS NOT a OpenXT issue, read `doc/csproj-guide.md` for more detail. 

OpenXT currently supports bash, fish, and ~~powershell~~. You may run the following command to enable your
shell session to work on CoreXT projects: 

```bash
# bash-only
openxt env --shell bash --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache" | source
rider .../xxx.sln
```

```bash
# fish-only
openxt env --shell fish --project-dir "~/code/Azure-Deployment-Builder" --local-repo-dir "/mnt/hdd/CxCache" | source
dotnet build
```

# TODO

[DONE!] 1. Use the framework version in HintPath to download package. (bugfix)

2. deps de-duplicate

3. Parallelize `openxt sync` with multiple fake environment. 

4. possible coreXT design issue: If `myProject/subproject1` requires pkgA:net472, 
   and `myProject/subproject2` requires pkgA:net451. And pkgA:1.0.1 only provides net451, 
   and pkgA:1.0.2 only provides net472, it booms. 
