#include <cis-workflow-gen/quick-include.hpp>

int main() {
    auto flow =
        Activity("CreateResGrp", "FleetAGC.Activities.InitResourceGroupActivity")
            .addInputSetting("ResourceGroup", "WdsTest")
        >> Activity("CreateVM", "FleetAGC.Activities.CreateAzureResourceActivity")
            .addInputSetting("ResourceGroup", "WdsTest")
            .addInputSetting("DeploymentName", "DeployVM")
            .addInputSetting("TemplateFilePath", "Resources/ArmTemplates/VM/Template_winserver2016.json")
            .addInputSetting("ParameterFilePath", "Resources/ArmTemplates/VM/Parameters_WDS.json")
        >> Activity("WaitForCreateVM", "FleetAGC.Activities.QueryAzureVMsActivity")
            .addInputSetting("ResourceGroup", "WDSSeedingServer")
        >> Activity("InstallWdsServices", "FleetAGC.Activities.RemotePSActivity")
            .addInputSetting("PublicIP", "\" + GlobalSettings[\"GlobalAdminPublicIPAddress\"] + \"")
            .addInputSetting("UserNameKey", "DC1AdminUserName")
            .addInputSetting("PasswordKey", "DC1AdminPassword")
            .addInputSetting("ScriptPath", "Resources/PSScript/WDSGo.ps1")
            .addInputSetting("RequiresSAS","true")
        >> Activity("WaitForWdsInstallFinish", "FleetAGC.Activities.RemotePSActivity")
            .addInputSetting("PublicIP", "\" + GlobalSettings[\"GlobalAdminPublicIPAddress\"] + \"")
            .addInputSetting("UserNameKey", "DC1AdminUserName")
            .addInputSetting("PasswordKey", "DC1AdminPassword")
            .addInputSetting("RetryTime", "2000")
            .addInputSetting("RetryInterval", "1")
            .addInputSetting("ScriptPath", "Resources/PSScript/WDSGo_CheckSuccess.ps1")
        ;

    println(to_file("DeployWdsTestServerWorkflow.xaml"), flow.generateXaml("Microsoft.Office.FleetAGC.Workflows.DeployWdsTestServerWorkflow"));
}

// TODO: WDS server requires more UDP port to be opened. But we don't know the client's ip address. 
//       So, would security team be happy if we open UDP 67 and 69 to public? 

