#ifndef CIS_WF_GEN_UUID_HPP
#define CIS_WF_GEN_UUID_HPP

#include <random>
#include <string>
#include <rlib/string.hpp>

namespace Utility {


inline static auto GenUUID() {
    static std::random_device dev;
    static std::mt19937 rng(dev());

    std::uniform_int_distribution<int> dist(0, 15);

    const char *v = "0123456789ABCDEF";
    const bool dash[] = { 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0 };

    std::string res;
    for (int i = 0; i < 16; i++) {
        if (dash[i]) res += "-";
        res += v[dist(rng)];
        res += v[dist(rng)];
    }
    return res;
}

inline static auto HtmlEscapeString(rlib::string s) {
    return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
}

}

#endif