#include <cis-workflow-gen/quick-include.hpp>

int main() {
// This is a DEMO. You may use any C++17 syntax here. 

// 先演示一下定义一个Activity和ManualOperation的正常语法。
//                  (ActivityName,   ClassName_In_Our_Code            , DependencyEntityName)
Activity HaveASleep ("HaveASleep", "FleetAGC.Activities.DelayActivity", "");
HaveASleep.addInputSetting("Timespan", "60");
//                           (DisplayName   ,   Message             ,  TeamId to alert   , DependencyEntityName)
ManualOperation AlertSomeone ("AlertSomeone", "This is some message", "AzDNetDeployments", "");
// 但是如果你要定义很多很多Activity，建议下面的方法偷懒。

////////////////////////////////////////////////////////////////////////////////////////////////

{ // 偷懒方案1
    // 这里假设你想用FleetAGC.Activities.DelayActivity，并且想给他一个TimeSpan参数。
    #define AC(name, entityName) \
            auto name = Activity(#name, "FleetAGC.Activities.DelayActivity", #entityName).addInputSetting("Timespan", "60");
       
    // 使用刚刚定义的偷懒宏。
    AC(GridManager, M365Poc.SPO.GridManager)
    AC(AuthAndProvision, M365Poc.SPO.AuthProvisioning)
    AC(FarmsAndTennats, )
    AC(CSC , )
    AC(FastSearch , )
    AC(Microservices, M365Poc.SPO.MicroServices)
    AC(MonitorAndAlert, M365Poc.SPO.MonitoringAlerting)
    AC(SPOTooling, M365Poc.SPO.SPOTooling)
    AC(UXCDNFailover, M365Poc.SPO.UXCDNFailover)
    AC(ODFBSyncClient, M365Poc.SPO.ODFBSyncClient)
    
    // 把定义好的Activity组合一下，其中箭头表示串行，竖线表示并行。
    auto block1 = GridManager >> FarmsAndTennats >> (CSC | FastSearch);
    auto block2 = Microservices | MonitorAndAlert;
    auto completeFlow = block1 | AuthAndProvision | block2 >> SPOTooling | UXCDNFailover | ODFBSyncClient;
    
    // 最后指定一下workflow的名字就可以了。
    println(completeFlow.generateXaml("FleetAGC.Workflows.SPOBuildoutPOCWorkflow"));
}

////////////////////////////////////////////////////////////////////////////////////////////////

if constexpr(false) { // 偷懒方案2
    #define A_2(name, entityName) (Activity(#name, "FleetAGC.Activities.DelayActivity", #entityName).addInputSetting("Timespan", "60"))
    #define A_1(name) A_2(name, )
    #define A_proxy(x, Arg1, Arg2, FUNC, ...) FUNC
    #define A(...) A_proxy(, ##__VA_ARGS__, A_2(__VA_ARGS__), A_1(__VA_ARGS__))
    
    // 和上一个例子一样的语法，只不过这次更懒了。
    auto block1 = A(GridManager, M365Poc.SPO.GridManager) >> A(FarmsAndTennats) >> (A(CSC) | A(FastSearch));
    auto block2 = A(Microservices, M365Poc.SPO.MicroServices) | A(MonitorAndAlert, M365Poc.SPO.MonitoringAlerting);
    auto completeFlow = block1 | A(AuthAndProvision, M365Poc.SPO.AuthProvisioning) | block2 | A(SPOTooling, M365Poc.SPO.SPOTooling) | A(UXCDNFailover, M365Poc.SPO.UXCDNFailover) | A(ODFBSyncClient, M365Poc.SPO.ODFBSyncClient);
    
    // 最后指定一下workflow的名字就可以了。
    println(completeFlow.generateXaml("FleetAGC.Workflows.SPOBuildoutPOCWorkflow"));
}

}