// This is a DEMO. You may use any C++17 syntax here. 

// 先用这种语法定义每一个单独的Activity。
//                  (ActivityName,   ClassName_In_Our_Code            , DependencyEntityName)
Activity HaveASleep ("HaveASleep", "FleetAGC.Activities.DelayActivity", "");
HaveASleep.addInputSetting("Timespan", "60");

// 不想把上面的定义复制粘贴很多遍。那就偷个懒。
#define DEFINE_ACTIVITY(name, entityName) \
        Activity name (#name, "FleetAGC.Activities.DelayActivity", entityName); \
        name.addInputSetting("Timespan", "60");
    
// 使用刚刚定义的偷懒宏。
DEFINE_ACTIVITY(GridManager, "M365Poc.SPO.GridManager")
DEFINE_ACTIVITY(AuthAndProvision, "M365Poc.SPO.AuthProvisioning")
DEFINE_ACTIVITY(FarmsAndTennats, "")
DEFINE_ACTIVITY(CSC , "")
DEFINE_ACTIVITY(FastSearch , "")
DEFINE_ACTIVITY(Microservices, "M365Poc.SPO.MicroServices")
DEFINE_ACTIVITY(MonitorAndAlert, "M365Poc.SPO.MonitoringAlerting")
DEFINE_ACTIVITY(SPOTooling, "M365Poc.SPO.SPOTooling")
DEFINE_ACTIVITY(UXCDNFailover, "M365Poc.SPO.UXCDNFailover")
DEFINE_ACTIVITY(ODFBSyncClient, "M365Poc.SPO.ODFBSyncClient")

// 把定义好的Activity组合一下，其中箭头表示串行，竖线表示并行。
auto block1 = GridManager >> FarmsAndTennats >> (CSC | FastSearch);
auto block2 = Microservices | MonitorAndAlert;
auto completeFlow = block1 | AuthAndProvision | block2 | SPOTooling | UXCDNFailover | ODFBSyncClient;

// 最后指定一下workflow的名字就可以了。
println(completeFlow.generateXaml("FleetAGC.Workflows.SPOBuildoutPOCWorkflow"));

