#ifndef CIS_WORKFLOW_GEN_DIRTY_PLUGIN_HPP
#define CIS_WORKFLOW_GEN_DIRTY_PLUGIN_HPP

#include <rlib/string.hpp>
#include "xaml-template.hpp"

namespace CIS::dirty_plugins {
    rlib::string patchGS(const rlib::string &input) {
        rlib::string output (input);
        auto pos_seq = output.find("ControlledSequence");
        auto pos_par = output.find("ControlledParallel");
        rlib::string plugin_text = CIS::templates::PLUGIN_GlobalSettingsVariable_SEQ;
        if(pos_seq == rlib::string::npos && pos_par == rlib::string::npos)
            return output;
        else if(pos_seq == rlib::string::npos || pos_par < pos_seq)
            plugin_text.replace("ControlledSequence", "ControlledParallel");
        // else OutMost is sequence, nothing to do. 
            
        return output.replace_once(">\n", ">\n" + plugin_text);
    }
}

#endif

