#include <cis-workflow-gen/quick-include.hpp>

int main() {
    #define A_2(name, entityName) (Activity(#name, "FleetAGC.Activities.DelayActivity", #entityName).addInputSetting("Timespan", "60"))
    #define A_1(name) A_2(name, "")
    #define A_proxy(x, Arg1, Arg2, FUNC, ...) FUNC
    #define A(...) A_proxy(, ##__VA_ARGS__, A_2(__VA_ARGS__), A_1(__VA_ARGS__))
 
    auto block1 = A(GridManager, M365Poc.SPO.GridManager) >> A(FarmsAndTennats) >> (A(CSC) | A(FastSearch));
    auto block2 = A(Microservices, M365Poc.SPO.MicroServices) | A(MonitorAndAlert, M365Poc.SPO.MonitoringAlerting);
    auto completeFlow = block1 | A(AuthAndProvision, M365Poc.SPO.AuthProvisioning) | block2 | A(SPOTooling, M365Poc.SPO.SPOTooling) | A(UXCDNFailover, M365Poc.SPO.UXCDNFailover) | A(ODFBSyncClient, M365Poc.SPO.ODFBSyncClient);
 
    println(to_file("SPOBuildoutPOCWorkflow.xaml"), completeFlow.generateXaml("FleetAGC.Workflows.SPOBuildoutPOCWorkflow"));
}

