# Antidote-CIS

> Use Open Standards, Open Data, Open Source, and Open Innovation. 

This project includes a simple, cross-platform, portable CIS client. You can upload, release, view CIS packages, and run CIS workflows easily in command line, which makes CIS development experience easier. 

Designed for linux, can 100% run on windows and macOS, but not tested. It is your own business to install all dependencies and make sure they are working. 

## Dependency

All these dependencies are confirmed to support Linux (natively), WSL (natively), and win32. 
These dependencies could also be found on BSD, MacOS, and any OS with a working C++ compiler. 

json2table >1.0.6 <https://git.recolic.net/root/json2table>, bash, curl, unix binutil (cut,cat,tr,grep,,find,curl).

You may also need bearer-gen to generate bearer-token from PFX in your config file: <https://m365fleetagc.visualstudio.com/Core/_git/bearer-gen>

> If you are a Windows user, refer to <https://m365fleetagc.visualstudio.com/Core/_git/antidote-CIS-windows>

## Usage

### 1 - Install the script

Just copy `antidote-cis` and `antidote.config.sh` to your PATH. It's usually `/usr/bin/` on linux. 

### 2 - Read and modify config file

Read and modify `antidote.config.sh`. You **must** set `cis_cookie` or `cis_bearer` to access CIS API. You may also want to set `cis_namespace`, `cis_default_workflow_name`, `cis_default_workflow_parameter` to your own value. 

If you're familiar to CIS, you should know how to set them.

### 3 - Ready for use

You **must run** `antidote-cis` to read help message before using. It's also suggested to go through this README to avoid misunderstanding. 

## Shell Auto-Completion

Currently we only supports fish-shell. Please copy `completions/antidote-cis.fish` into one of your `$fish_complete_path`, and enjoy! 

## FAQ

### What is the difference between "Workflow Parameters" and "Runtime Settings"?

These "AdditionalSettings" in the screenshot are "RuntimeSettings", and these parameters are "WorkflowParameters". 

For example, if your workflow looks like this: 

![screenshot](doc/2.png)

You need to do the same thing with my tool, like this: 

```
antidote-cis cloudrun BootstrapDCSeedingServerWorkflow <version_number> \
  Alias=11 \
  TargetMachineAlias=22 \
  DomainName=33 \
  @RunEnvironment=CISBeta \
  @SubscriptionId=420f71ab-35f2-4550-9de6-7c8fab764b4d \
  @ApplicationId=a55b6ede-49b2-4d89-ae5d-983b28e5095f \
  @AgCloudName=AG98 \
  @EcsAgentName=M365FleetAGC \
  @Location=westus2 \
  @StageName=Stage-0
```

### Where could I upload package from? 

- Push from local directory

```
antidote-cis push path/to/my/workflow ...
```

- Push from existing samba share or shared folder

> The samba share must be located in CORPNET

```
antidote-cis push smb://YOUR_MACHINE/your/folder ... 
```

- Push from CIS itself (trigger an upload)

You may have a package in BuildReady state. You need to "trigger an upload" without any argument to upload it.   
In this case, you run `antidote-cis push cis:// BuildDomainControllerWorkflow 1.0.8.415`. You should not omit its version. 

![screenshot](doc/1.png)

### Are there any pre-built windows release? 

Windows users are lazy, and installing software on Windows is much much more difficult than Linux and Unix. So I have to provide a prebuilt windows release: <https://m365fleetagc.visualstudio.com/Core/_git/antidote-CIS-windows>

### What is cis namespace? 

CIS namespace means CIS JobType. We use the term "namespace" in this project, because it's easier to understand. 

### Error: Failed to check the status of uploading job, HTTP 403

Checking the status of package uploading requires read access to `System` JobType. To do this, you can modify `src/Configuration/CIS/TenantRoles/BetaOverride/System.json` of the OneDCMT repo. 

### File content is not identical after jobtype-upload and jobtype-download

After uploading a XML into CIS, it *might* perform `unix2dos` operation, and it *might* trim the tailing newline. This is done inside CIS, and it's out of our control. 

## misc notes

version number should not contain space.   
workflowname and version number should not contain `=`   
workflow paramters should not contain `'` 

only tested on bash > 4.0.0. please report bug if there's problem on bash 3.x. 

This script is only tested within M365FleetAGC team. Please report bug if you realize it not working for you! (Please mailto: bensl@microsoft.com)

