# Antidote-CIS

> Use Open Standards, Open Data, Open Source, and Open Innovation. 

This project includes a simple, cross-platform, portable CIS client. may also include a modified `smbd` (samba server) to upload package to CIS. You can upload, release, view CIS packages, and run CIS workflows easily in command line, which makes CIS development experience easier. 

Designed for linux, can 100% run on windows and macOS, but not tested. It is your own business to install all dependencies and make sure they are working. 

## Dependency

All these dependencies are confirmed to support Linux (natively), WSL (natively), and win32 (Use your google to find smbclient for win32). 
These dependencies could also be found on BSD, MacOS, and any OS with a working C++ compiler. 

json2table >1.0.6 <https://git.recolic.net/root/json2table>, bash, smbclient <https://wiki.archlinux.org/index.php/samba#Client>, curl, unix binutil (cut,cat,tr,grep,,find,curl).

## Usage

### 1 - Install the script

Just copy `antidote-cis` and `antidote.config.sh` to your PATH. It's usually `/usr/bin/` on linux. 

### 2 - Read and modify config file

Read and modify `antidote.config.sh`. You must set `cis_cookie` and `smb_namespace`, and you may also want to modify `cis_namespace`, `cis_default_workflow_name`, `cis_default_workflow_parameter` to yours. 

If you're familiar to CIS, you should know how to set them.

### 3 - Ready for use

Please run `antidote-cis` to read help message before using. Also fully read this README to avoid misunderstanding. 

## Push package from different sources

- Push from existing samba share

This is the easiest situation. Just run `antidote-cis push //Your/Samba/Link/To/Folder ...`, and it works perfectly without `smbclient`. 

- Push from local directory

You need to make sure `smbclient` is installed, and modify `antidote.config.sh` to correctly set samba server login information. 

- Push from CIS itself (trigger an upload)

You may have a package in BuildReady state. You need to "trigger an upload" without any argument to upload it.   
In this case, you run `antidote-cis push cis:// BuildDomainControllerWorkflow 1.0.8.415`. You should not omit its version. 

![screenshot](doc/1.png)

## Workflow parameters and Runtime Settings

These "AdditionalSettings" in the screenshot are "RuntimeSettings", and these parameters are "WorkflowParameters". 

For example, if your workflow looks like this: 

![screenshot](doc/2.png)

You need to do the same thing with my tool, like this: 

```
antidote-cis cloudrun BootstrapDCSeedingServerWorkflow <version_number> \
  Alias=11 \
  TargetMachineAlias=22 \
  DomainName=33 \
  @RunEnvironment=CISBeta \
  @SubscriptionId=420f71ab-35f2-4550-9de6-7c8fab764b4d \
  @ApplicationId=a55b6ede-49b2-4d89-ae5d-983b28e5095f \
  @AgCloudName=AG98 \
  @EcsAgentName=M365FleetAGC \
  @Location=westus2 \
  @StageName=Stage-0
```

# notes

version number should not contain space.   
workflowname and version number should not contain `=`   
workflow paramters should not contain `'` 

only tested on bash > 4.0.0. please report bug if there's problem on bash 3.x. 

This script is only tested within M365FleetAGC team. Please report bug if you realize it not working for you! (Please mailto: bensl@microsoft.com)

smbclient for windows is not working. Possible solution from: http://www.allandynes.com/2016/05/samba-client-for-windows-smbclient-exe-v3-6-25/ , https://recolic.net/blog/post/build-smbclient-for-windows

