# This configuration file is a standard bash script. 
# You may use any bash commands/syntax here. 

##################################################################################################
############################ Upload package without your own samba share #########################
##################################################################################################

# Samba shared account. The share should be writable for all users. 
# You can use the built-in shared account, provided by bensl@microsoft.com. You can also build your own. 
# Warning that, RECOLICWINBOX maybe offline on Saturday and Sunday (UTC+8). 
# smb_provider=//RECOLICVWIN.fareast.corp.microsoft.com/public-smb-share
smb_provider=//RECOLICMSMPC.fareast.corp.microsoft.com/bus
smb_username=public
smb_password=P@ssw0rd

# This should be your own unique domain name. 
# Antidote use this domain name as folder name, to avoid collision with other users. 
# It's ok to use any string here, but others would be angry if you accidently violates their namespace. 
smb_namespace=recolic.net

##################################################################################################
######################################## CIS Authentication ######################################
##################################################################################################

## cis_cookie is usually only valid for 1 day. So we recommend you to whitelist your APP and get an CIS bearer from APP certificate. 
# cis_cookie="ai_user=8NPqe|2021-03-16T04:54:14.790Z; .AspNet.Cookies=6f_au9znzZ_rfWCOxar269NgOJTiU97XZ-qY4sq_4R18DkomSE2cWMw; ai_session=FMrYO29.615"
# cis_bearer="Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsIng1dCI6Imwzc1EtNeLQx5JTXu7K4zeNw3hq1F-w"
cis_bearer="Bearer `bearer-gen http://microsoft.com/beta-cps ed857452-e380-4621-a248-a2764e8cb70c /path/to/my-certificate.pfx`"

##################################################################################################
######################################### CIS Settings ###########################################
##################################################################################################

# CIS "namespace" is CIS "JobType". If it's not set in environment variable, set it. 
[[ -z $cis_namespace ]] || cis_namespace=M365FleetAGCTest
# If you are ommiting workflow name in your command line arguments, this is the default value. 
cis_default_workflow_name=SampleWorkflow
# These default arguments could be overriden by command line arguments. Use it if it makes your life easier. 
cis_default_workflow_parameter=(
    Alias=bensl
    Date=08/23/1999

    ### Here are some examples for workflow parameters:
    ###
    ### ParameterName=Value
    # DomainName=mydomain.example.com
    # UserName=recolic_setup
    # PasswordKey=CAPasswordKey
    ### Use true/false to represent boolean parameter. 
    # IsFirstDC=true
    ### Use quote symbols at your will
    # SiteName="This is a very good site"
    # DomainPassword='A("x8*e#@`!^b'
    ### Use bash syntax at your will
    # PublicIP="$(curl https://api.ipify.org)"

    ### Here are some examples for Runtime Settings: (Read README if you don't know what's this)
    ###
    ### @ParameterName=Value
    # @SubscriptionId=420f71ab-35f2-4550-9de6-7c8fab764b4d
    # @Region=westus2
    # @AgCloudName=AG98

    # This RuntimeSetting is required for EVERY workflow! 
    @RunEnvironment=CISBeta
)



