// Copyright 2016 Citra Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#include "core/core.h"
#include "core/settings.h"
#include "ui_configure_general.h"
#include "yuzu/configuration/configure_general.h"
#include "yuzu/ui_settings.h"

ConfigureGeneral::ConfigureGeneral(QWidget* parent)
    : QWidget(parent), ui(new Ui::ConfigureGeneral) {

    ui->setupUi(this);

    this->setConfiguration();

    ui->cpu_core_combobox->setEnabled(!Core::System::GetInstance().IsPoweredOn());
    ui->is_docked->setEnabled(!Core::System::GetInstance().IsPoweredOn());
}

ConfigureGeneral::~ConfigureGeneral() {}

void ConfigureGeneral::setConfiguration() {
    ui->toggle_deepscan->setChecked(UISettings::values.gamedir_deepscan);
    ui->toggle_check_exit->setChecked(UISettings::values.confirm_before_closing);
    ui->cpu_core_combobox->setCurrentIndex(static_cast<int>(Settings::values.cpu_core));
    ui->is_docked->setChecked(Settings::values.is_docked);
}

void ConfigureGeneral::applyConfiguration() {
    UISettings::values.gamedir_deepscan = ui->toggle_deepscan->isChecked();
    UISettings::values.confirm_before_closing = ui->toggle_check_exit->isChecked();
    Settings::values.cpu_core =
        static_cast<Settings::CpuCore>(ui->cpu_core_combobox->currentIndex());
    Settings::values.is_docked = ui->is_docked->isChecked();
    Settings::Apply();
}
