// SPDX-FileCopyrightText: Ryujinx Team and Contributors
// SPDX-License-Identifier: MIT

#include "core/hle/service/mii/raw_data.h"

namespace Service::Mii::RawData {

const std::array<Service::Mii::DefaultMii, 2> BaseMii{
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 0,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 33,
        .hair_color = 1,
        .hair_flip = 0,
        .eye_type = 2,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 4,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 6,
        .eyebrow_color = 1,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Male,
        .favorite_color = 0,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 0,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 12,
        .hair_color = 1,
        .hair_flip = 0,
        .eye_type = 4,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 3,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 0,
        .eyebrow_color = 1,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Female,
        .favorite_color = 0,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
};

const std::array<Service::Mii::DefaultMii, 6> DefaultMii{
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 4,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 68,
        .hair_color = 0,
        .hair_flip = 0,
        .eye_type = 2,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 4,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 6,
        .eyebrow_color = 0,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Male,
        .favorite_color = 4,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 0,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 55,
        .hair_color = 6,
        .hair_flip = 0,
        .eye_type = 2,
        .eye_color = 4,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 4,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 6,
        .eyebrow_color = 6,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Male,
        .favorite_color = 5,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 1,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 33,
        .hair_color = 1,
        .hair_flip = 0,
        .eye_type = 2,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 4,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 6,
        .eyebrow_color = 1,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Male,
        .favorite_color = 0,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 2,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 24,
        .hair_color = 0,
        .hair_flip = 0,
        .eye_type = 4,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 3,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 0,
        .eyebrow_color = 0,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Female,
        .favorite_color = 2,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 0,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 14,
        .hair_color = 7,
        .hair_flip = 0,
        .eye_type = 4,
        .eye_color = 5,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 3,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 0,
        .eyebrow_color = 7,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Female,
        .favorite_color = 6,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },
    Service::Mii::DefaultMii{
        .face_type = 0,
        .face_color = 0,
        .face_wrinkle = 0,
        .face_makeup = 0,
        .hair_type = 12,
        .hair_color = 1,
        .hair_flip = 0,
        .eye_type = 4,
        .eye_color = 0,
        .eye_scale = 4,
        .eye_aspect = 3,
        .eye_rotate = 3,
        .eye_x = 2,
        .eye_y = 12,
        .eyebrow_type = 0,
        .eyebrow_color = 1,
        .eyebrow_scale = 4,
        .eyebrow_aspect = 3,
        .eyebrow_rotate = 6,
        .eyebrow_x = 2,
        .eyebrow_y = 10,
        .nose_type = 1,
        .nose_scale = 4,
        .nose_y = 9,
        .mouth_type = 23,
        .mouth_color = 0,
        .mouth_scale = 4,
        .mouth_aspect = 3,
        .mouth_y = 13,
        .mustache_type = 0,
        .beard_type = 0,
        .beard_color = 0,
        .mustache_scale = 4,
        .mustache_y = 10,
        .glasses_type = 0,
        .glasses_color = 0,
        .glasses_scale = 4,
        .glasses_y = 10,
        .mole_type = 0,
        .mole_scale = 4,
        .mole_x = 2,
        .mole_y = 20,
        .height = 64,
        .weight = 64,
        .gender = Gender::Female,
        .favorite_color = 7,
        .region = 0,
        .font_region = FontRegion::Standard,
        .type = 0,
    },

};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiFaceline{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 0, 1, 2, 2, 3, 4, 5, 6, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 13,
        .values = {0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 0, 1, 2, 2, 3, 4, 5, 6, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 0, 1, 2, 2, 3, 4, 5, 6, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 13,
        .values = {0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 0, 1, 2, 2, 3, 4, 5, 6, 7, 10, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 10,
        .values = {0, 0, 1, 1, 2, 3, 4, 5, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 8, 10},
    },
};

const std::array<Service::Mii::RandomMiiData3, 6> RandomMiiFacelineColor{
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 0,
        .values_count = 10,
        .values = {2, 2, 4, 4, 4, 4, 5, 5, 5, 5},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 1,
        .values_count = 10,
        .values = {0, 0, 0, 0, 1, 1, 2, 3, 3, 3},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 2,
        .values_count = 10,
        .values = {0, 0, 1, 1, 1, 1, 1, 1, 1, 2},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 0,
        .values_count = 10,
        .values = {2, 2, 4, 4, 4, 4, 5, 5, 5, 5},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 1,
        .values_count = 10,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 1, 3},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 2,
        .values_count = 10,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 1, 1},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiFacelineWrinkle{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 4, 4, 8, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 4, 4, 8, 8},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 4, 4},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 20,
        .values = {9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiFacelineMakeup{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiHairType{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 30,
        .values = {13, 23, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 43, 44, 45,
                   47, 48, 49, 50, 51, 52, 54, 56, 57, 64, 66, 75, 76, 86, 89},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 31,
        .values = {13, 23, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 43, 44, 45, 47,
                   48, 49, 50, 51, 52, 54, 56, 57, 64, 66, 73, 75, 81, 86, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 31,
        .values = {13, 23, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 43, 44, 45, 47,
                   48, 49, 50, 51, 52, 54, 56, 57, 64, 66, 73, 75, 81, 86, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 38,
        .values = {13, 23, 30, 31, 32, 33, 34, 36, 37, 38, 40, 42, 43, 44, 45, 47, 48, 49, 50,
                   51, 52, 53, 54, 55, 56, 58, 59, 60, 64, 65, 66, 67, 68, 70, 75, 76, 86, 89},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 39,
        .values = {13, 23, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 43, 44, 45, 47, 48, 49, 50, 51,
                   52, 53, 54, 55, 56, 58, 59, 60, 64, 65, 66, 67, 68, 70, 73, 75, 81, 86, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 39,
        .values = {13, 23, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 43, 44, 45, 47, 48, 49, 50, 51,
                   52, 53, 54, 55, 56, 58, 59, 60, 64, 65, 66, 67, 68, 70, 73, 75, 81, 86, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 18,
        .values = {13, 23, 30, 36, 37, 41, 45, 47, 51, 53, 54, 55, 58, 59, 65, 67, 86, 88},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 19,
        .values = {13, 23, 30, 36, 37, 39, 41, 45, 47, 51, 53, 54, 55, 58, 59, 65, 67, 86, 88},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 19,
        .values = {13, 23, 30, 36, 37, 39, 41, 45, 47, 51, 53, 54, 55, 58, 59, 65, 67, 86, 88},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 39,
        .values = {0,  1,  2,  3,  4,  5,  6,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
                   21, 22, 24, 25, 26, 28, 46, 50, 61, 62, 63, 64, 69, 76, 77, 79, 80, 83, 85},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 42,
        .values = {0,  1,  2,  3,  4,  5,  6,  8,  9,  10, 11, 12, 13, 14,
                   15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 28, 46, 50,
                   61, 62, 63, 64, 69, 72, 74, 77, 78, 82, 83, 84, 85, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 42,
        .values = {0,  1,  2,  3,  4,  5,  6,  8,  9,  10, 11, 12, 13, 14,
                   15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 28, 46, 50,
                   61, 62, 63, 64, 69, 72, 74, 77, 78, 82, 83, 84, 85, 87},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 44,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
                   15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 29, 42, 50,
                   58, 60, 62, 63, 64, 69, 71, 76, 79, 80, 81, 82, 83, 86},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 44,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
                   15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 29, 50, 58,
                   60, 62, 63, 64, 69, 71, 72, 74, 79, 81, 82, 83, 84, 85},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 44,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
                   15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 29, 50, 58,
                   60, 62, 63, 64, 69, 71, 72, 74, 79, 81, 82, 83, 84, 85},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 24,
        .values = {0,  1,  2,  3,  4,  5,  6,  10, 11, 12, 13, 14,
                   16, 17, 18, 20, 21, 24, 25, 58, 62, 69, 76, 83},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 27,
        .values = {0,  1,  2,  3,  4,  5,  6,  10, 11, 12, 13, 14, 16, 17,
                   18, 20, 21, 24, 25, 58, 62, 69, 74, 76, 81, 83, 85},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 27,
        .values = {0,  1,  2,  3,  4,  5,  6,  10, 11, 12, 13, 14, 16, 17,
                   18, 20, 21, 24, 25, 58, 62, 69, 74, 76, 81, 83, 85},
    },
};

const std::array<RandomMiiData3, 9> RandomMiiHairColor{
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 0,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 1,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 0,
        .arg_2 = 2,
        .values_count = 20,
        .values = {0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 0,
        .values_count = 20,
        .values = {2, 3, 3, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 1,
        .values_count = 20,
        .values = {2, 3, 3, 3, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 1,
        .arg_2 = 2,
        .values_count = 20,
        .values = {2, 3, 3, 4, 4, 4, 4, 4, 4, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 2,
        .arg_2 = 0,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 2,
        .arg_2 = 1,
        .values_count = 20,
        .values = {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3},
    },
    Service::Mii::RandomMiiData3{
        .arg_1 = 2,
        .arg_2 = 2,
        .values_count = 20,
        .values = {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiEyeType{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 26,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 15, 16, 18, 27,
                   29, 32, 34, 36, 38, 39, 41, 43, 47, 49, 51, 53, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 26,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 15, 16, 18, 27,
                   29, 32, 34, 36, 38, 39, 41, 43, 47, 49, 51, 53, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 27,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 15, 16, 18, 26, 27,
                   29, 32, 34, 36, 38, 39, 41, 43, 47, 48, 49, 53, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 35,
        .values = {2,  3,  5,  6,  7,  8,  9,  11, 12, 13, 15, 16, 17, 18, 21, 22, 27, 29,
                   31, 32, 34, 36, 37, 38, 39, 41, 43, 44, 47, 49, 51, 53, 55, 56, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 35,
        .values = {2,  3,  5,  6,  7,  8,  9,  11, 12, 13, 15, 16, 17, 18, 21, 22, 27, 29,
                   31, 32, 34, 36, 37, 38, 39, 41, 43, 44, 47, 49, 51, 53, 55, 56, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 35,
        .values = {2,  3,  5,  6,  7,  8,  9,  11, 12, 13, 15, 16, 18, 21, 22, 26, 27, 29,
                   31, 32, 34, 36, 37, 38, 39, 41, 43, 44, 47, 48, 49, 50, 53, 56, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 30,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 14, 15, 16, 17, 18, 21,
                   22, 31, 32, 34, 36, 37, 39, 41, 44, 49, 51, 53, 55, 56, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 30,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 14, 15, 16, 17, 18, 21,
                   22, 31, 32, 34, 36, 37, 39, 41, 44, 49, 51, 53, 55, 56, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 30,
        .values = {2,  3,  5,  7,  8,  9,  11, 12, 13, 14, 15, 16, 18, 21, 22,
                   26, 31, 32, 34, 36, 37, 39, 41, 44, 48, 49, 50, 51, 53, 57},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 39,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23, 24, 25, 27,
                   28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 39,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23, 24, 25, 27,
                   28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 40,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23, 24, 25, 26,
                   27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 46,
        .values = {0,  1,  2,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 15, 16, 17,
                   18, 19, 20, 21, 23, 24, 25, 27, 28, 29, 30, 32, 33, 34, 35, 37,
                   38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 58, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 46,
        .values = {0,  1,  2,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 15, 16, 17,
                   18, 19, 20, 21, 23, 24, 25, 27, 28, 29, 30, 32, 33, 34, 35, 37,
                   38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 58, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 46,
        .values = {0,  1,  2,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18,
                   19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 37,
                   38, 39, 40, 41, 42, 45, 46, 47, 48, 53, 54, 57, 58, 59},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 34,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23,
                   24, 25, 27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 34,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23,
                   24, 25, 27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 35,
        .values = {0,  1,  2,  4,  5,  7,  8,  9,  10, 11, 12, 13, 15, 16, 18, 19, 23, 24,
                   25, 26, 27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 45, 46, 47},
    },
};

const std::array<Service::Mii::RandomMiiData2, 3> RandomMiiEyeColor{
    Service::Mii::RandomMiiData2{
        .arg_1 = 0,
        .values_count = 10,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1},
    },
    Service::Mii::RandomMiiData2{
        .arg_1 = 1,
        .values_count = 10,
        .values = {0, 1, 1, 2, 3, 3, 4, 4, 4, 5},
    },
    Service::Mii::RandomMiiData2{
        .arg_1 = 2,
        .values_count = 10,
        .values = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiEyebrowType{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 20},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 20},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 20},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 23,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11,
                   12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 23,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11,
                   12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 23,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11,
                   12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 21,
        .values = {0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 21,
        .values = {0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 21,
        .values = {0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 9,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 9,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 9,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 11,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13, 15, 19},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 11,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13, 15, 19},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 11,
        .values = {0, 1, 3, 7, 8, 9, 10, 11, 13, 15, 19},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 9,
        .values = {0, 3, 7, 8, 9, 10, 11, 13, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 9,
        .values = {0, 3, 7, 8, 9, 10, 11, 13, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 9,
        .values = {0, 3, 7, 8, 9, 10, 11, 13, 15},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiNoseType{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 11,
        .values = {0, 1, 2, 3, 4, 5, 7, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 11,
        .values = {0, 1, 2, 3, 4, 5, 7, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 11,
        .values = {0, 1, 2, 3, 4, 5, 7, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 15,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 18,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 15,
        .values = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 8,
        .values = {0, 1, 3, 4, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 8,
        .values = {0, 1, 3, 4, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 8,
        .values = {0, 1, 3, 4, 8, 10, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 12,
        .values = {0, 1, 3, 4, 6, 8, 9, 10, 11, 13, 14, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 11,
        .values = {0, 1, 3, 4, 6, 8, 9, 10, 11, 13, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 10,
        .values = {0, 1, 3, 4, 6, 8, 10, 11, 13, 14},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 12,
        .values = {0, 1, 3, 4, 6, 8, 9, 10, 11, 13, 14, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 11,
        .values = {0, 1, 3, 4, 6, 8, 9, 10, 11, 13, 15},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 10,
        .values = {0, 1, 3, 4, 6, 8, 10, 11, 13, 14},
    },
};

const std::array<Service::Mii::RandomMiiData4, 18> RandomMiiMouthType{
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 25,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 12, 14, 15, 17, 18,
                   19, 21, 22, 23, 25, 26, 28, 30, 32, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 27,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 17,
                   18, 19, 21, 22, 23, 25, 26, 28, 30, 32, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 28,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 17,
                   18, 19, 21, 22, 23, 25, 26, 28, 30, 31, 32, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 24,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 12, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 26,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
                   16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 26,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
                   16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 24,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 12, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 26,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
                   16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Male,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 26,
        .values = {0,  2,  3,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
                   16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Black,
        .values_count = 25,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 14, 15,
                   17, 18, 19, 21, 22, 23, 25, 26, 30, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Black,
        .values_count = 26,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 17, 18, 19, 21, 22, 23, 25, 26, 30, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Black,
        .values_count = 26,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 17, 18, 19, 21, 22, 23, 25, 26, 30, 33, 34, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::White,
        .values_count = 25,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 14, 15,
                   17, 18, 19, 21, 22, 23, 24, 26, 27, 29, 33, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::White,
        .values_count = 26,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 17, 18, 19, 21, 22, 23, 24, 26, 27, 29, 33, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::White,
        .values_count = 25,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 17, 18, 19, 21, 22, 23, 24, 25, 29, 33, 35},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Young,
        .race = Race::Asian,
        .values_count = 24,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 14,
                   15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 29, 33},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Normal,
        .race = Race::Asian,
        .values_count = 25,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 29, 33},
    },
    Service::Mii::RandomMiiData4{
        .gender = Gender::Female,
        .age = Age::Old,
        .race = Race::Asian,
        .values_count = 25,
        .values = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  12, 13, 14,
                   15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 29, 33},
    },
};

const std::array<Service::Mii::RandomMiiData2, 3> RandomMiiGlassType{
    Service::Mii::RandomMiiData2{
        .arg_1 = 0,
        .values_count = 9,
        .values = {90, 94, 96, 100, 0, 0, 0, 0, 0},
    },
    Service::Mii::RandomMiiData2{
        .arg_1 = 1,
        .values_count = 9,
        .values = {83, 86, 90, 93, 94, 96, 98, 100, 0},
    },
    Service::Mii::RandomMiiData2{
        .arg_1 = 2,
        .values_count = 9,
        .values = {78, 83, 0, 93, 0, 0, 98, 100, 0},
    },
};

} // namespace Service::Mii::RawData
