// Copyright 2014 Citra Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#include "common/log.h"
#include "core/hle/hle.h"
#include "core/hle/kernel/event.h"
#include "core/hle/service/y2r_u.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
// Namespace Y2R_U

namespace Y2R_U {

const Interface::FunctionInfo FunctionTable[] = {
    {0x00010040, nullptr,                 "SetInputFormat"},
    {0x00030040, nullptr,                 "SetOutputFormat"},
    {0x00050040, nullptr,                 "SetRotation"},
    {0x00070040, nullptr,                 "SetBlockAlignment"},
    {0x000D0040, nullptr,                 "SetTransferEndInterrupt"},
    {0x000F0000, nullptr,                 "GetTransferEndEvent"},
    {0x00100102, nullptr,                 "SetSendingY"},
    {0x00110102, nullptr,                 "SetSendingU"},
    {0x00120102, nullptr,                 "SetSendingV"},
    {0x00180102, nullptr,                 "SetReceiving"},
    {0x001A0040, nullptr,                 "SetInputLineWidth"},
    {0x001C0040, nullptr,                 "SetInputLines"},
    {0x00200040, nullptr,                 "SetStandardCoefficient"},
    {0x00220040, nullptr,                 "SetAlpha"},
    {0x00260000, nullptr,                 "StartConversion"},
    {0x00270000, nullptr,                 "StopConversion"},
    {0x00280000, nullptr,                 "IsBusyConversion"},
    {0x002A0000, nullptr,                 "PingProcess"},
    {0x002B0000, nullptr,                 "DriverInitialize"},
    {0x002C0000, nullptr,                 "DriverFinalize"}
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Interface class

Interface::Interface() {
    Register(FunctionTable, ARRAY_SIZE(FunctionTable));
}
    
} // namespace
