// Copyright 2019 yuzu Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#pragma once

#include "core/frontend/emu_window.h"

struct SDL_Window;

class EmuWindow_SDL2_Hide : public Core::Frontend::EmuWindow {
public:
    explicit EmuWindow_SDL2_Hide();
    ~EmuWindow_SDL2_Hide();

    /// Polls window events
    void PollEvents() override;

    /// Makes the graphics context current for the caller thread
    void MakeCurrent() override;

    /// Releases the GL context from the caller thread
    void DoneCurrent() override;

    /// Whether the screen is being shown or not.
    bool IsShown() const override;

    /// Retrieves Vulkan specific handlers from the window
    void RetrieveVulkanHandlers(void* get_instance_proc_addr, void* instance,
                                void* surface) const override;

    /// Whether the window is still open, and a close request hasn't yet been sent
    bool IsOpen() const;

private:
    /// Whether the GPU and driver supports the OpenGL extension required
    bool SupportsRequiredGLExtensions();

    /// Internal SDL2 render window
    SDL_Window* render_window;

    using SDL_GLContext = void*;
    /// The OpenGL context associated with the window
    SDL_GLContext gl_context;
};
