// Copyright 2018 yuzu emulator team
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#include "core/hle/service/sockets/ethc.h"

namespace Service::Sockets {

ETHC_C::ETHC_C() : ServiceFramework{"ethc:c"} {
    // clang-format off
    static const FunctionInfo functions[] = {
        {0, nullptr, "Initialize"},
        {1, nullptr, "Cancel"},
        {2, nullptr, "GetResult"},
        {3, nullptr, "GetMediaList"},
        {4, nullptr, "SetMediaType"},
        {5, nullptr, "GetMediaType"},
    };
    // clang-format on

    RegisterHandlers(functions);
}

ETHC_I::ETHC_I() : ServiceFramework{"ethc:i"} {
    // clang-format off
    static const FunctionInfo functions[] = {
        {0, nullptr, "GetReadableHandle"},
        {1, nullptr, "Cancel"},
        {2, nullptr, "GetResult"},
        {3, nullptr, "GetInterfaceList"},
        {4, nullptr, "GetInterfaceCount"},
    };
    // clang-format on

    RegisterHandlers(functions);
}

} // namespace Service::Sockets
