// Copyright 2014 Citra Emulator Project
// Licensed under GPLv2
// Refer to the license.txt file included.  

#include <map>

#include "core/hle/function_wrappers.h"
#include "core/hle/syscall.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
// Namespace Syscall

namespace Syscall {

Result SVC_ConnectToPort(void* out, const char* port_name) {
    NOTICE_LOG(OSHLE, "svcConnectToPort called, port_name: %s", port_name);
    return 0;
}

const HLE::FunctionDef Syscall_Table[] = {
    {0x00,  NULL,                           "Unknown"},
    {0x01,  NULL,                           "svcControlMemory"},
    {0x02,  NULL,                           "svcQueryMemory"},
    {0x03,  NULL,                           "svcExitProcess"},
    {0x04,  NULL,                           "svcGetProcessAffinityMask"},
    {0x05,  NULL,                           "svcSetProcessAffinityMask"},
    {0x06,  NULL,                           "svcGetProcessIdealProcessor"},
    {0x07,  NULL,                           "svcSetProcessIdealProcessor"},
    {0x08,  NULL,                           "svcCreateThread"},
    {0x09,  NULL,                           "svcExitThread"},
    {0x0A,  NULL,                           "svcSleepThread"},
    {0x0B,  NULL,                           "svcGetThreadPriority"},
    {0x0C,  NULL,                           "svcSetThreadPriority"},
    {0x0D,  NULL,                           "svcGetThreadAffinityMask"},
    {0x0E,  NULL,                           "svcSetThreadAffinityMask"},
    {0x0F,  NULL,                           "svcGetThreadIdealProcessor"},
    {0x10,  NULL,                           "svcSetThreadIdealProcessor"},
    {0x11,  NULL,                           "svcGetCurrentProcessorNumber"},
    {0x12,  NULL,                           "svcRun"},
    {0x13,  NULL,                           "svcCreateMutex"},
    {0x14,  NULL,                           "svcReleaseMutex"},
    {0x15,  NULL,                           "svcCreateSemaphore"},
    {0x16,  NULL,                           "svcReleaseSemaphore"},
    {0x17,  NULL,                           "svcCreateEvent"},
    {0x18,  NULL,                           "svcSignalEvent"},
    {0x19,  NULL,                           "svcClearEvent"},
    {0x1A,  NULL,                           "svcCreateTimer"},
    {0x1B,  NULL,                           "svcSetTimer"},
    {0x1C,  NULL,                           "svcCancelTimer"},
    {0x1D,  NULL,                           "svcClearTimer"},
    {0x1E,  NULL,                           "svcCreateMemoryBlock"},
    {0x1F,  NULL,                           "svcMapMemoryBlock"},
    {0x20,  NULL,                           "svcUnmapMemoryBlock"},
    {0x21,  NULL,                           "svcCreateAddressArbiter"},
    {0x22,  NULL,                           "svcArbitrateAddress"},
    {0x23,  NULL,                           "svcCloseHandle"},
    {0x24,  NULL,                           "svcWaitSynchronization1"},
    {0x25,  NULL,                           "svcWaitSynchronizationN"},
    {0x26,  NULL,                           "svcSignalAndWait"},
    {0x27,  NULL,                           "svcDuplicateHandle"},
    {0x28,  NULL,                           "svcGetSystemTick"},
    {0x29,  NULL,                           "svcGetHandleInfo"},
    {0x2A,  NULL,                           "svcGetSystemInfo"},
    {0x2B,  NULL,                           "svcGetProcessInfo"},
    {0x2C,  NULL,                           "svcGetThreadInfo"},
    {0x2D,  WrapI_VC<SVC_ConnectToPort>,    "svcConnectToPort"},
    {0x2E,  NULL,                           "svcSendSyncRequest1"},
    {0x2F,  NULL,                           "svcSendSyncRequest2"},
    {0x30,  NULL,                           "svcSendSyncRequest3"},
    {0x31,  NULL,                           "svcSendSyncRequest4"},
    {0x32,  NULL,                           "svcSendSyncRequest"},
    {0x33,  NULL,                           "svcOpenProcess"},
    {0x34,  NULL,                           "svcOpenThread"},
    {0x35,  NULL,                           "svcGetProcessId"},
    {0x36,  NULL,                           "svcGetProcessIdOfThread"},
    {0x37,  NULL,                           "svcGetThreadId"},
    {0x38,  NULL,                           "svcGetResourceLimit"},
    {0x39,  NULL,                           "svcGetResourceLimitLimitValues"},
    {0x3A,  NULL,                           "svcGetResourceLimitCurrentValues"},
    {0x3B,  NULL,                           "svcGetThreadContext"},
    {0x3C,  NULL,                           "svcBreak"},
    {0x3D,  NULL,                           "svcOutputDebugString"},
    {0x3E,  NULL,                           "svcControlPerformanceCounter"},
    {0x3F,  NULL,                           "Unknown"},
    {0x40,  NULL,                           "Unknown"},
    {0x41,  NULL,                           "Unknown"},
    {0x42,  NULL,                           "Unknown"},
    {0x43,  NULL,                           "Unknown"},
    {0x44,  NULL,                           "Unknown"},
    {0x45,  NULL,                           "Unknown"},
    {0x46,  NULL,                           "Unknown"},
    {0x47,  NULL,                           "svcCreatePort"},
    {0x48,  NULL,                           "svcCreateSessionToPort"},
    {0x49,  NULL,                           "svcCreateSession"},
    {0x4A,  NULL,                           "svcAcceptSession"},
    {0x4B,  NULL,                           "svcReplyAndReceive1"},
    {0x4C,  NULL,                           "svcReplyAndReceive2"},
    {0x4D,  NULL,                           "svcReplyAndReceive3"},
    {0x4E,  NULL,                           "svcReplyAndReceive4"},
    {0x4F,  NULL,                           "svcReplyAndReceive"},
    {0x50,  NULL,                           "svcBindInterrupt"},
    {0x51,  NULL,                           "svcUnbindInterrupt"},
    {0x52,  NULL,                           "svcInvalidateProcessDataCache"},
    {0x53,  NULL,                           "svcStoreProcessDataCache"},
    {0x54,  NULL,                           "svcFlushProcessDataCache"},
    {0x55,  NULL,                           "svcStartInterProcessDma"},
    {0x56,  NULL,                           "svcStopDma"},
    {0x57,  NULL,                           "svcGetDmaState"},
    {0x58,  NULL,                           "svcRestartDma"},
    {0x59,  NULL,                           "Unknown"},
    {0x5A,  NULL,                           "Unknown"},
    {0x5B,  NULL,                           "Unknown"},
    {0x5C,  NULL,                           "Unknown"},
    {0x5D,  NULL,                           "Unknown"},
    {0x5E,  NULL,                           "Unknown"},
    {0x5F,  NULL,                           "Unknown"},
    {0x60,  NULL,                           "svcDebugActiveProcess"},
    {0x61,  NULL,                           "svcBreakDebugProcess"},
    {0x62,  NULL,                           "svcTerminateDebugProcess"},
    {0x63,  NULL,                           "svcGetProcessDebugEvent"},
    {0x64,  NULL,                           "svcContinueDebugEvent"},
    {0x65,  NULL,                           "svcGetProcessList"},
    {0x66,  NULL,                           "svcGetThreadList"},
    {0x67,  NULL,                           "svcGetDebugThreadContext"},
    {0x68,  NULL,                           "svcSetDebugThreadContext"},
    {0x69,  NULL,                           "svcQueryDebugProcessMemory"},
    {0x6A,  NULL,                           "svcReadProcessMemory"},
    {0x6B,  NULL,                           "svcWriteProcessMemory"},
    {0x6C,  NULL,                           "svcSetHardwareBreakPoint"},
    {0x6D,  NULL,                           "svcGetDebugThreadParam"},
    {0x6E,  NULL,                           "Unknown"},
    {0x6F,  NULL,                           "Unknown"},
    {0x70,  NULL,                           "svcControlProcessMemory"},
    {0x71,  NULL,                           "svcMapProcessMemory"},
    {0x72,  NULL,                           "svcUnmapProcessMemory"},
    {0x73,  NULL,                           "Unknown"},
    {0x74,  NULL,                           "Unknown"},
    {0x75,  NULL,                           "Unknown"},
    {0x76,  NULL,                           "svcTerminateProcess"},
    {0x77,  NULL,                           "Unknown"},
    {0x78,  NULL,                           "svcCreateResourceLimit"},
    {0x79,  NULL,                           "Unknown"},
    {0x7A,  NULL,                           "Unknown"},
    {0x7B,  NULL,                           "Unknown"},
    {0x7C,  NULL,                           "svcKernelSetState"},
    {0x7D,  NULL,                           "svcQueryProcessMemory"},
};

void Register() {
    HLE::RegisterModule("SyscallTable", ARRAY_SIZE(Syscall_Table), Syscall_Table);
}

} // namespace
