# 常见问题

## 与新页面 / 新功能 / 错误反馈相关的问题

### 我找不到我所在地区的健康码模拟，该怎么办？

由于开发能力有限，不太可能逐一满足每个人的需求，所以单独的新项目提议可能会被忽略。有时会在 [Telegram 频道](https://t.me/gh_ilovexjp) 上进行匿名调查，这时为你需要的项目投票即可。

无论你如何反馈，刷屏通常只会带来反效果。

### 为什么健康码模拟和真实的不同？

如果你发现健康码模拟与真实健康码不同，请先检查：

- 是否存在不同平台的版本？有时我们的模拟项目是针对特定平台（微信 / 支付宝 /网页）进行制作，可能与你所使用的平台不同。导航栏在不同操作系统下的显示也可能不相同。
- 你发现的不同点是否存在于所有人的健康码中？有时你的健康码可能与其他人不同，比如模拟通常会是打过新冠疫苗加强针的健康码，可能会和没有疫苗接种的健康码不同。
- 你所使用的是否为特定地区的健康码？模拟的健康码通常是依据使用该码的主要城市制作，可能与其它城市有所不同。

如果仍发现模拟健康码的不同之处，你可以到 [Reddit 社区](https://reddit.com/r/ILoveHealthCode) 反馈，或发送邮件至 ilovexjp@protonmail.com。

### 目前项目没有我想要的页面或功能，该向哪里反馈？

这些提议通常都已经有人提出，你可以逛逛 [Reddit 社区](https://reddit.com/r/ILoveHealthCode)。如果没有人提出，可以在置顶贴内分享你的想法。

### 能不能增加黄码/红码功能？

不会增加这个功能。项目的初衷是反抗这个在极权下极端防疫的反科学产物——健康码，而不是推崇、利用它。

### 能不能付费定制功能？

目前不接受付费定制。

## 与使用相关的问题

### iPhone 14 Pro Max 1TB 上怎么用 / 我是华为手机，怎么用 / 小米在哪下 / 有没有 apk 安装包？

本项目只有网页版，请使用浏览器访问网页演示：[ilovexjp.pages.dev](https://ilovexjp.pages.dev)。

### 我打不开网页演示，怎么办？

请检查网络连接（在中国大陆访问通常需要代理）及代理工具。另外可以尝试自行部署或使用信任的人部署的版本。

### 如何全屏使用？

添加至主屏幕（安装 PWA）后就可以全屏使用了。具体的方法因浏览器不同而不同，如 iOS Safari 中，点击下方“共享”按钮，再点击“添加至主屏幕”；Android Chrome / Firefox 中，点击右上角“菜单”按钮，再点击“添加至主屏幕”或“安装”。

### 如何离线使用？

置顶的项目或访问过的项目会自动预加载。预加载完成后会在项目右侧“打勾”，“打勾”的项目在离线时将可以正常使用。

### 使用这个项目会不会上传我输入的数据？

正常情况下，所有的输入数据都只会在本地处理，不会上传。但如果有恶意服务商篡改了网页源码，是有可能收集到你的所有输入的。所以，请选择你信任的服务商，或自行部署。

### 如何清空我输入过的数据？

可以点击目录页下的“清除本地数据”，或在浏览器设置中清除访问数据。

### 使用这个项目会不会被人发现？

会。

### 使用这个项目能不能通过机器扫描？

不能。

### 我下载了源码压缩包，但页面加载出现异常，这是为什么？

请不要直接解压缩源码并打开，源码需要部署在 Web 服务器上。

### 我正在用全面屏的 iPhone，但状态栏上的文字消失了，该怎么办？

请点击项目目录页右上角的“帮助”按钮了解更多。

## 与部署相关的问题

### 我该如何自行部署这个项目？

你需要一台 Web 服务器，或是部署到提供这类服务的平台上。请访问 [Codeberg Releases](https://codeberg.org/ilovexjp/health-code-simulator/releases) 下载最新供部署的 `health-code-simulator.zip` 源码，再将其复制到网站根目录下。如果在部署时遇到问题，请多多利用搜索引擎解决。

### 我自行部署了项目，但有些功能和网页演示中不同，怎么办？

很多功能（预加载、摄像头等）可能需要开启 HTTPS 才能使用，请为服务器配置上 HTTPS 环境。

### 我自行将源码部署到了 Web 服务器上的非根目录下，但目录页面和行程卡的跳转出了问题，该如何修复？

请修改 `common/base.js` 中的 `root_path` 常量，将其调整为健康码模拟在网站中的路径。

## 其它

### 我该如何参与开发？

欢迎你的加入，请通过信任的邮件服务商发送邮件至 ilovexjp@protonmail.com，简要说明一下自己就可以！请在可以保证自身安全的前提下进行，不要透露可定位到个人的信息。
