﻿RevokeChinaCerts
==============

### Usage
* Run `RevokeChinaCerts_CodeSigning.bat` or `RevokeChinaCerts_Organization.bat` and follow the messages on screen.
* Setting force requires administrative privileges and Microsoft .NET Framework 4.0 or later version.

### Version
* **1** is **All** version, revoke all listed CodeSigning/Organization certificates.
* **2** is **Restore** version, restore all listed revoking CodeSigning/Organization certificates.
* Choice version is no longer available. Please remove the certificate fingerprint(s) in /Windows/Certificates/CodeSigning/CodeSigning.txt or /Windows/Certificates/Organization/Organization.txt to make it/them not to be revoked.

### About Certificates
* **CodeSigning** list

Name | Expire Time | Fingerprint
:---:|:---:|---
[21CN Corporation Limited](https://www.21cn.com) | 2019-01-10 | 2D285D849B888F8CCC45596C030B025183B8965D
[2345.Com](https://www.2345.com) | 2016-05-23 | 47011FE975A3D9E17EF1A118F5695B3FB97BEAE3
[2345.Com](https://www.2345.com) | 2016-05-23 | B6070B587AFB5CEBECA17F2ACA02A0314CBC8839
[2345.Com](https://www.2345.com) | 2017-09-03 | 741C8C6560CFF170368F3F73CA4D03C853C78F8B
[2345.Com](https://www.2345.com) | 2017-09-03 | C9DB2CBC5E9D019D1A445610B5EC608D5F773DB4
3721.Com | 2005-01-20 | A28C8E7AE778009B5FA55825D94BE73ADAF6A16E
[Alibaba (China) Network Technology Co.,Ltd.](https://www.alibaba.com) | 2018-07-17 | C89040E946519C487DAB998C35F32D8EC34293B1
[Alibaba (China) Network Technology Co.,Ltd.](https://www.alibaba.com) | 2018-07-17 | D33D2B039D97254FDC35D75254AFE8B1D9BE245D
[Alibaba (China) Network Technology Co.,Ltd.](https://www.alibaba.com) | 2019-08-28 | 17007BAD8ABA2D2B9D1A9ECE57CF03A365D42282
[Alibaba (China) Network Technology Co.,Ltd.](https://www.alibaba.com) | 2019-08-29 | B09FEB13859DC8ABBD271602E8EBCDAA222A4F9B
[Alibaba (Hangzhou) Cultural Innovation Co.,Ltd.](https://www.xiami.com) | 2019-11-17 | 989BF64AA3E0AC411DE9A66DF1A6CC861DC4C23B
[Alibaba (Hangzhou) Cultural Innovation Co.Ltd.](https://www.xiami.com) | 2017-11-17 | 2E98A468D7DDBE489B2AF6317A555DBBA16598EA
[Alipay.com Co.,Ltd](https://www.alipay.com) | 2015-09-15 | 5C3523B19C304DE2A320E19FD757B3957D69BDD4
[Baidu (China) Co., Ltd.](https://www.baidu.com) | 2015-02-22 | A34B70840C2B6F718877DDB1C2DE2C27F2C91C43
[Baidu (China) Co., Ltd.](https://www.baidu.com) | 2017-02-12 | 0E6193159596F8150ED9ED2A402E67C28FAAC1BE
[Beijing Baidu Netcom Science and Technology Co.,Ltd](https://www.baidu.com) | 2020-02-07 | 39824F745667F9A28B7BC7614F6D1A29529E21E2
[Beijing baidu Netcom science and technology co.ltd](https://www.baidu.com) | 2015-02-27 | D60C12D1FDB9E45551A00C8815CCD486C043945B
[BeiJing Baidu Netcom Science Technology Co., Ltd](https://www.baidu.com) | 2016-02-07 | 03FCF1B9FCAB6F7243F3E3E011C6FD28F64F9920
[BeiJing Baidu Netcom Science Technology Co., Ltd](https://www.baidu.com) | 2018-02-07 | ACAED4BE8C729A6AE5F4F82F5F183A9C4EBE7AE3
[Beijing Baofeng Technology Co., Ltd.](http://www.baofeng.com) | 2015-02-22 | CB6F65314E5B25D61304AB2C9C8870B574CC21F5
[Beijing Baofeng Technology Co., Ltd.](http://www.baofeng.com) | 2016-04-06 | CC79F55AB07E7A1D5CEC981CEEB864DDA5DC74E3
[Beijing Baofeng Technology Co., Ltd.](http://www.baofeng.com) | 2018-05-06 | BBC26FF3B96FF570D96A75ED09FF8F11481E7EF5
[BeiJing Eastern Micropoint Info-Tech CO., LTD](http://www.micropoint.com.cn) | 2015-07-02 | 7909C1ABCD50813B0C3004E7468A3CC4BFAAE34D
[BeiJing Eastern Micropoint Info-Tech CO., LTD](http://www.micropoint.com.cn) | 2018-08-07 | 4893C5890F8DA1AFE9DF91EE3AE678B2AC782F41
[Beijing Funshion Online Technologies Ltd.](https://www.fun.tv) | 2016-08-02 | 9AB5445104C6CCE5A22431CF29C4331CBC328A1B
[Beijing Funshion Online Technologies Ltd.](https://www.fun.tv) | 2018-08-02 | 9A39D144805FA9AF799829DF72C521ACACBB026D
[Beijing Hai Yu Dong Xiang Technology Co., Ltd.](http://www.haimawan.com) | 2017-08-17 | C7ACB2AF1A4DA1A20FAB7385CE044A14A8D4C9BD
[Beijing Jiangmin New Sci.&Tec. Co. Ltd.](https://www.jiangmin.com) | 2013-07-12 | 8E853D78D6BB8E2911E0F102827C19126D290E36
[Beijing Jiangmin New Sci.&Tec. Co. Ltd.](https://www.jiangmin.com) | 2014-08-30 | D02D3BB43F3AFD9D6C77884E2CE4A8E3E47DD07B
[Beijing Jiangmin New Sci.&Tec. Co. Ltd.](https://www.jiangmin.com) | 2017-11-03 | C555780B84AEFA9BAAE26FDA390138713157B6AF
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2014-12-26 | E88DD1ACD2DB3A352072AA49C675F4944A3FEF82
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2016-01-29 | CC9467907AD45574588F4E16F29CA36D5F78C0F8
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2017-02-20 | AB9B532CCC20DF35533B1B878B5F2FCE75405679
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2017-02-20 | CA1C10FA2E56B5BAD83D087233F15D898EFF0C54
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2019-03-20 | 6B4AC106BB9C99DCF85269C7FD86019D354EDF5F
[Beijing Kingsoft Security software Co.,Ltd](http://www.kingsoft.com) | 2020-03-15 | 13623E691B0CC4BDC296EEC27DB945BF5A200840
[BEIJING KUWO TECHNOLOGY CO.,LTD.](http://www.kuwo.cn) | 2017-01-03 | 5FFFD1A3EAE5ED74558913C4A8476D1514C6D61F
[BEIJING KUWO TECHNOLOGY CO.,LTD.](http://www.kuwo.cn) | 2017-01-03 | CC0C4F060CBCC3FCF34397B47D5B3EA66580CFFF
[BEIJING KUWO TECHNOLOGY CO.,LTD.](http://www.kuwo.cn) | 2020-02-15 | E492DE96A46D79CE158DB7F12814405A5819DD22
[Beijing Qihu Technology Co., Ltd.](https://www.360.cn) | 2020-02-02 | 8A72A3BDF9922793F9D06C70511DFFFA49004511
[Beijing Qihu Technology Co., Ltd.](https://www.360.cn) | 2020-02-02 | A50E0BABE5EE7DC261B0C122A8641A37E1CE4CE3
[BEIJING QIYI CENTURY SCIENCE&TECHNOLOGY CO.,LTD.](https://www.iqiyi.com) | 2017-02-10 | 5DC57AF121E3101F4BFEA8A22BBDADC0869C80EE
[BEIJING QIYI CENTURY SCIENCE&TECHNOLOGY CO.,LTD.](https://www.iqiyi.com) | 2017-02-10 | DB3EDE9E5C203A4CC43A453F74D06D79C42946D1
[BEIJING QIYI CENTURY SCIENCE&TECHNOLOGY CO.,LTD.](https://www.iqiyi.com) | 2020-02-02 | 18427E6D2F947FB629D1D13F96136AE425231063
[BEIJING QIYI CENTURY SCIENCE&TECHNOLOGY CO.,LTD.](https://www.iqiyi.com) | 2020-02-02 | 8638C32145474071F6F66220E575779D066B1CF0
[Beijing Rising Information Technology Corporation Limited](http://www.rising.com.cn) | 2015-08-11 | D9421BEDD9F5B8A91DD3F8691E7A42D83C983325
[Beijing Rising Information Technology Corporation Limited](http://www.rising.com.cn) | 2018-09-08 | 6D6AFC4A6E24B3441B872B9995E37CA8D2BC4609
[Beijing Rising Information Technology Corporation Limited](http://www.rising.com.cn) | 2018-09-08 | BB22AEDFC634E3DC119B926E648CDE494E12A798
[Beijing Rising Network Security Technology Co., Ltd.](http://www.rising.com.cn) | 2019-08-31 | 2EF8879CE4EBE73CDD9F218F349913D5958885C6
[Beijing Rising Network Security Technology Co., Ltd.](http://www.rising.com.cn) | 2019-08-31 | 966A3FD30BD88F6947577EBC9D487DB73383BC25
[Beijing Sogou Technology Development Co., Ltd.](https://www.sogou.com) | 2019-09-28 | 1E4AE0F42F243BF603737B6298D1CEA649408AC8
[Beijing Sogou Technology Development Co., Ltd.](https://www.sogou.com) | 2021-08-31 | F1B0AEC91A8E893932046EE6BD9E5B634F9A6304
[Beijing Sohu New Media Information Technology Co., Ltd.](https://www.sohu.com) | 2014-11-29 | D1BB252CAC3D250C55978F7EAAF121DA91A17B42
[CA 沃通根证书](https://www.wosign.com) | 2025-04-30 | 3FB343D3CF454603510C3B969445068C5BFEF12A
[Certification Authority of WoSign](https://www.wosign.com) | 2019-07-10 | 1C1ECDCCF764E6168177C5711F33EC9229A29F88
[Certification Authority of WoSign](https://www.wosign.com) | 2025-04-30 | B74827E3D6BF9DFFD85111680688244DB8C269FE
[China Mobile Group Guangdong Co., Ltd. Mobile Internet Branch](https://www.10086.cn) | 2016-01-09 | 14DE17539FF05E234FAAFAE49CD30870ABD2F5F7
[China Mobile Internet Company Limited](https://www.10086.cn) | 2017-01-25 | 16CC2B7ABC7C5728AE08A5C6FD9DC849690C75E0
[FOX INFORMATION TECHNOLOGY (TIANJIN) LIMITED](https://www.sohu.com) | 2017-12-31 | 89FB07619BFEC398C258221AB54DB5D761F061FA
[Fuzhou BoYuan Wireless Websoft Technology Ltd.](http://zs.91.com) | 2014-06-01 | 76F273B12A88EAB4B086DEB23875E35710446DA7
[Guangzhou Tieren Network Technology Co.,Ltd.](https://www.25pp.com) | 2015-08-19 | 2529C0C0D833806AFBFA3C31987C19A18722A2FE
[Guangzhou Tieren Network Technology Co.,Ltd.](https://www.25pp.com) | 2018-07-13 | 6505AD4DC89D1E592A47E839359E6918A0407EBF
[Haiyu Dongxiang Co.,Ltd](http://www.haimawan.com) | 2016-08-26 | 0C763003F5360492F9A90B5156E0387961F04993
[Hangzhou Alibaba Music Technology Co., Ltd](https://www.xiami.com) | 2021-10-18 | FCB37DFE25E91F0C265A8C03F9D3282D1C86F570
[Hangzhou Shunwang Technology Co.,Ltd](http://www.icafe8.com) | 2018-01-23 | E93763AF668D36E8ACE49D299A91A0544C1CC09C
[Hangzhou Shunwang Technology Co.,Ltd](http://www.icafe8.com) | 2018-12-28 | CDD6129FF5884112C7F1AA55A035C8F8922DBFFF
[Hangzhou Shunwang Technology Co.,Ltd](http://www.icafe8.com) | 2019-01-02 | A1803A82A608068BEFDDF393B794EA1E8074538D
[Hangzhou Shunwang Technology Co.,Ltd](http://www.icafe8.com) | 2020-01-09 | 28EAB8BE954486400E0653BF33010B7CD5BBB52D
[Hangzhou Shunwang Technology Co.,Ltd](http://www.icafe8.com) | 2020-01-10 | F57956CCD6F9A9B60AA2C9DE335026532C44C06D
[Kingsoft Security Co.,Ltd](http://www.kingsoft.com) | 2016-04-06 | 2BDEC50B4446652C126709A08248E572B859CCCC
[LE SHI INTERNET INFORMATION & TECHNOLOGY CORP.,BEI JING](https://www.le.com) | 2017-01-08 | 62DF2BC4B5902B52C215C697D06038E3B28CF5D3
[LE SHI INTERNET INFORMATION & TECHNOLOGY CORP.,BEI JING](https://www.le.com) | 2017-06-18 | EC6FEFDCED80555081AF88C56F538F7575D8204F
[Maxthon (Asia) Limited.](https://www.maxthon.com) | 2015-07-15 | 1481414E8E87412A00D3341167FE3A92C681B830
[Maxthon (Asia) Limited.](https://www.maxthon.com) | 2018-08-28 | 5C7961E4A7020975FF67414435FA934BA87D1366
[Maxthon Technology Co, Ltd.](https://www.maxthon.com) | 2021-07-11 | 3F27A35FE7AF06977138D02AD83DDBF13A67B7C3
[Mydrivers Information Technology Co., Ltd (ZhengZhou)](http://www.drivergenius.com) | 2015-07-04 | 982414EF52175D9693630F7CD2E69F317886A5F2
[NetEase(Hangzhou) Network Co. Ltd.](https://www.163.com) | 2016-06-21 | E0387F3AF5752A4620EC617C39153C0E666CF5F8
[NetEase(Hangzhou) Network Co. Ltd.](https://www.163.com) | 2019-02-27 | E90DC0AC8B9EAE1DA53292626094CF800CEF2BC0
[NetEase(Hangzhou) Network Co. Ltd.](https://www.163.com) | 2022-02-02 | 8172DA15CE2E086D8FBEB52963DBB4C59E9C29CA
[NetEase(Hangzhou) Network Co. Ltd.](https://www.163.com) | 2022-02-02 | 
[PPLive Corporation](https://www.pptv.com) | 2016-01-10 | 5477E38783CD37B1E5729B15D7C0873A2D72DB9D
[PPLive Corporation](https://www.pptv.com) | 2019-01-25 | 355A2A394F51E1D741D034FF102B345D5B27D846
[PPLive Corporation](https://www.pptv.com) | 2019-01-25 | B8DE8DBF3807F94364D4978766814637522D660C
[Qihoo 360 Software (Beijing) Company Limited](https://www.360.cn) | 2016-03-11 | 1E5BB77FCB63F26277F95AAE09B852699327A08A
[Qihoo 360 Software (Beijing) Company Limited](https://www.360.cn) | 2019-03-29 | 978859CE5698F2BFADE1129401CF70856BE738D3
[Qihoo 360 Software (Beijing) Company Limited](https://www.360.cn) | 2019-03-29 | D4FB2982268B592E3CD46FA78194E71418297741
[Shanda Computer (Shanghai) Co., Ltd.](http://www.kuaizip.com) | 2012-09-04 | 46190348CE9C5A50398A4E6E9B03496C1DDC1863
[Shanda Computer (Shanghai) Co., Ltd.](http://www.kuaizip.com) | 2013-09-24 | 9519AC9154A9BC7B8310C41D6FB6314EEF2A9A5B
[Shanghai 2345 Mobile Technology Co., Ltd.](https://www.2345.com) | 2019-06-23 | 3AAC97B3888128A92C1E33F7FFA4DE04A7CECB8C
[Shanghai 2345 Mobile Technology Co., Ltd.](https://www.2345.com) | 2019-06-23 | 9D2B91BD45422E146FEC079DCD0DADAC970AD65B
[Shanghai 2345 Mobile Technology Co., Ltd.](https://www.2345.com) | 2019-06-23 | D133E4D3613F3CD636E72BFD8E54B4176891401E
[Shanghai 2345 Mobile Technology Co., Ltd.](https://www.2345.com) | 2019-06-23 | D8702B9F8F243138C77EA151CAEDD24BB5AF9A86
[Shanghai 2345 Network Technology Co.,Ltd](https://www.2345.com) | 2017-06-16 | BEC0FDB1D836BB8C0A1C5B90907C146EF8F66353
[Shanghai 2345 Network Technology Co.,Ltd](https://www.2345.com) | 2018-07-24 | AA6299B2BE01E3B18B575AE19921C935639827A3
[Shanghai 2345 Network Technology Co.,Ltd](https://www.2345.com) | 2019-05-07 | E974E39CB8F94426DECE0C767E8181B372DF907A
[Shanghai Quan Tudou Network Technology Co., Ltd.](https://www.tudou.com) | 2015-06-28 | 935140881F50BDF775D3CEF034C0D21C18FD2567
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2016-01-26 | 294952E04EE73FA1935E756841F0FE11477F993B
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2018-02-08 | 52618B2F6389127082A2E208ECD70234019DF6E8
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2018-02-08 | AFC10A7F6628C214982E23B1C166A21F0BF3E7DF
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2019-03-27 | 5C751D510638D349554435AA82A455B35984A103
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2019-03-27 | 849C6E4C6B64A0389D6AC0379F89FF3347210D21
[Shenzhen DriveTheLife Software Technology Co.Ltd](https://www.160.com) | 2020-04-25 | 873E24977220C304A7EDD57D885C02BBFA6E1562
[Shenzhen Smartspace Software technology Co.,Limited](https://www.160.com) | 2017-04-20 | 78A149F9A04653B01DF09743571DF938F9873FA5
[Shenzhen Thinksky Technology Co.,Ltd](https://www.itools.cn) | 2014-05-19 | B443DD956C623D53863C2443B6D10C04A4FB3A4A
[Shenzhen Thinksky Technology Co.,Ltd](https://www.itools.cn) | 2018-06-09 | 4C681FDEBC70813C8495F134E6A0A8578C7E37B1
[Shenzhen Thinksky Technology Co.,Ltd](https://www.itools.cn) | 2019-07-13 | CD624E9C10BBF83A5D36D647A07794AFE924D44D
[ShenZhen Thunder Networking Technologies Ltd.](https://www.xunlei.com) | 2015-06-24 | 49A132170EFAE08EDDD9EE8A241B30BC947ACBD7
[ShenZhen Thunder Networking Technologies Ltd.](https://www.xunlei.com) | 2018-07-26 | 722C5A445662B35D5233BFDCF8EFF612C88A0332
[ShenZhen Thunder Networking Technologies Ltd.](https://www.xunlei.com) | 2018-07-27 | 5C4F19D63931C00E239E4227DE41C60AF140F45B
[ShenZhen Thunder Networking Technologies Ltd.](https://www.xunlei.com) | 2018-07-27 | D0AE98E21429702CE68CFB1475D29E59CAC36F54
[ShenZhen Thunder Networking Technologies Ltd.](https://www.xunlei.com) | 2020-03-29 | 6E85C97B057398E7AB6BE24DAC5A4524804BE620
[ShenZhen Xunlei Networking Technologies Ltd.](https://www.xunlei.com) | 2016-09-16 | 4099665730474153EADF671B8B475C03C08A46D0
[Sogou.Com](https://www.sogou.com) | 2012-07-15 | 34E11CCF5897AD9BD37A32FFB2B8F4AA21560847
[Sogou.Com](https://www.sogou.com) | 2015-08-25 | A72BBE1C7AA918B5BB1AD8E892DB1095A69C7035
[Sogou.com](https://www.sogou.com) | 2017-09-27 | D91D7B2C0FC2E792041CA3C5D35E67BBADA3C33E
[Sogou.Com](https://www.sogou.com) | 2018-09-29 | EB71F776677A00EA1DDBF1358A649E948836452A
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2016-06-22 | 87DD03AADF049F0E742AB2978CC190F4764A89BC
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2016-06-22 | E5777A69CAFD7F7C6F89C5297DD1159C7AE9B881
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2018-07-15 | 51133A37FFAD0B668844984E77109F29482D7DAB
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2018-07-15 | 9FFC6F20BA13B92C26B405E8F000213336AD1AA0
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2019-08-28 | 514C0E64A4BD2C7D6F2C0A41DDABD467087324AB
[TAOBAO (CHINA) SOFTWARE CO.,LTD.](https://www.taobao.com) | 2019-08-29 | 4FF8C27C10C1459C38C212D6835FD3B5FF886FEB
[TaoBao(china) Software Co., Ltd](https://www.taobao.com) | 2014-06-23 | 1B1D4D8444EB54B17CB5B999A50E1D0C0ED1BFE2
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2013-01-26 | 8B46390D86B891E5A3D3AAB2B00D6FDB27A0F791
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2016-02-17 | 2FDD445591CD2EEDBEF8B8A281896A59C08B3DC9
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2019-03-29 | 297124A7E7D4F2B46BD478AC7263A1369AC1738D
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2019-03-29 | C57B841B09620EA6278E62AF20963FAEC8F9E03D
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2020-02-03 | 545C2360D9ADF40A49FD497480CBCE9E25FC75D9
[Tencent Technology(Shenzhen) Company Limited](https://www.tencent.com) | 2020-02-03 | 8F0CC5B8F19D8CDECE2A7DD42F6C398663E1CE9B
[UC Mobile (China) Co., Ltd.](https://www.uc.cn) | 2021-08-29 | 146F12A722407201A6ACA6CC232D9949CBF049C8
[UC Mobile Limited](https://www.uc.cn) | 2015-01-06 | 1540C77B5D19FC5A71A04DB001488E55B45DDC7F
[Wandou Technology Ltd](https://www.wandoujia.com) | 2015-06-03 | AB09D1AFE555CFC580575F5BC78B16B9F1C4E432
[WoSign Code Signing Authority](https://www.wosign.com) | 2019-07-10 | EA36152981E296F9763E1DC74B3262D3928563F8
[WoSign Code Signing CA](https://www.wosign.com) | 2026-11-09 | 8EE115F1DBDF2F334F3917BBC09C684474A8A65D
[WoSign EV Code Signing Pro CA](https://www.wosign.com) | 2027-05-23 | 3CE2118D75A2258C53A3D7A26512160E09AA0FE9
[WoTrust Code Signing Authority](https://www.wosign.com) | 2019-07-10 | B28CCC46D234A7D7CF7F21CCB9406F48A5273CC6
Xiamen Yitianxia Network Technology Co., Ltd | 2015-01-02 | F49A648C69C2F01A0FDEB3992C5AE0A14D5AD9FC
[YY Inc.](https://www.yy.com) | 2015-09-21 | B3B89CD7940DC67E4291A3EE767AC17A3BC9E620
[YY Inc.](https://www.yy.com) | 2018-10-16 | 0C4D32BB2623387CD40C252DDB0F650DE6373385
[YY Inc.](https://www.yy.com) | 2018-10-16 | 2B70F74748E600BB0FA155C4ADABD3BF7B877261
[YY Inc.](https://www.yy.com) | 2019-11-09 | 56B47EE08D2B5B59BA324E02FFC5F89ABE0134A4
[Zhuhai Kingsoft Office Software Co., Ltd.](http://www.wps.cn) | 2020-02-04 | FECB40749830740C8864F66516711A7C8A04FE28
[Zhuhai Kingsoft Office Software Co., Ltd.](http://www.wps.cn) | 2020-02-05 | 12049E9EA3C44421480A380F224341112B1969A0
[Zhuhai Kingsoft Office Software Co.,Ltd](http://www.wps.cn) | 2017-04-20 | 95B1E59D73275C1582D1C7B88B5539E9DA9E2C6F
[Zhuhai Kingsoft Office Software Co.,Ltd](http://www.wps.cn) | 2017-04-20 | FA78FD28C1370371E8461D743114BAF1CD08A368
[Zhuhai Kingsoft Office Software Co.,Ltd](http://www.wps.cn) | 2018-05-29 | 8BED7372744EF5EA8E99E174260327193E8BEA9D
[Zhuhai Kingsoft Office Software Co.,Ltd](http://www.wps.cn) | 2018-05-29 | 97BBE4A840A419A00A771FEA8CA5248DA794CD34
[暴风集团股份有限公司](http://www.baofeng.com) | 2019-09-18 | 23F6E179C3B18C7EC114E24B4473BE132975A4F7
[北京海誉动想科技股份有限公司](http://www.haimawan.com) | 2018-08-05 | 40824B1FBF1DBF5D937FE34CCA9A34813A1538EE
[北京海誉动想科技股份有限公司](http://www.haimawan.com) | 2019-09-17 | 9D368037E942C1D31F7AD0EBBA3BCB719EDA24A2
北京飓风互动科技有限公司 | 2019-04-02 | F155A74AFF624A8D5C24F52D3FB4F35742B3469B
[福建博瑞网络科技有限公司](http://zs.91.com) | 2017-06-11 | E87D1C1D3FE2BCA700EB7B8DC0E45B97EAF19405
[福建智度科技有限公司](http://zs.91.com) | 2018-05-18 | 3E2508B896541F186A7B4AC6925F0ADDCC3677F2
[福建智度科技有限公司](http://zs.91.com) | 2018-05-25 | AE7AF8DCDB87EE2A178AE9B3EEAC0995D1D933CC
[福建智度科技有限公司](http://zs.91.com) | 2019-07-04 | BAD52E00A86FA49F70BD8F01606E81FBD21420AC
[福建智度科技有限公司](http://zs.91.com) | 2020-05-44 | 8FB74D6CF258DA5A67CE9FE7290C3A64FD14E62C
[广东雨林木风计算机科技有限公司](http://www.ylmf.com) | 2016-06-10 | 93A77CA50F165A5873DD3995874867B616AB3644
[广东雨林木风计算机科技有限公司](http://www.ylmf.com) | 2018-04-12 | 0303F86C94CD84A03095DF1B638B54218A942C4C
[海马云（天津）信息技术有限公司](http://www.haimawan.com) | 2018-11-10 | F2B6B943ACB10DED33FE47489CE04C450F2FB4CE
[杭州缪斯客网络科技有限公司](https://www.xiami.com) | 2014-08-22 | EEC507F719D5BA0CB913F034E045A24A509D8A5F
[合一网络技术（北京）有限公司](https://www.youku.com) | 2017-12-18 | B138DEFA2A4CF7C967515934344AC8649F5234A4
[合一网络技术（北京）有限公司](https://www.youku.com) | 2018-01-06 | 2067B2629A568B4B478EEBD12D9257CC2AF696A8
[合一网络技术（北京）有限公司](https://www.youku.com) | 2018-01-06 | 7CA5748E69272CB1164C4F6E37E7848A5DE46D96
[任子行网络技术股份有限公司](http://www.topfreeweb.net) | 2016-04-25 | 03BCB37634EB5585A14F1DD58AF7026F310D0362
[厦门美图网科技有限公司](https://www.meitu.com) | 2015-02-17 | 7B6FAE77BD19FEC5410293344B36124774A6D8F1
[厦门美图网科技有限公司](https://www.meitu.com) | 2017-02-19 | EBA2ADB1C0B7A61E5BA25B8356387F27049BA1A1
[厦门美图网科技有限公司](https://www.meitu.com) | 2020-03-19 | F1B4F51527AA613538E883CE69EDA31D54087979
[上海广乐网络科技有限公司](http://www.kuaizip.com) | 2015-08-02 | C64F3184E1D53D47D4527A06104131A11DCCCE62
[上海广乐网络科技有限公司](http://www.kuaizip.com) | 2017-09-14 | DD3E2E18FFD7CDDC3995CBF7D332D4F053300F5A
[上海广乐网络科技有限公司](http://www.kuaizip.com) | 2019-10-02 | 1AE7ED988E330C1A65C6F89E3B2408C38019028F
[上海广乐网络科技有限公司](http://www.kuaizip.com) | 2019-10-02 | 4D6513085F86A21AEDA2B11FE98B63408A3F6794
[上海剑圣网络科技有限公司](http://www.2144.cn) | 2015-03-29 | F7364B15B2DE2F85F5A882FFA4E2C3A3238FA0EC
[上海剑圣网络科技有限公司](http://www.2144.cn) | 2017-05-05 | E409EA5DE50F9DE7C2F8072BAAE2D0AF95874530
[上海剑圣网络科技有限公司](http://www.2144.cn) | 2020-05-07 | 6ED48DDB935F41F62A396EFDF77A1CA5836D39A2
[上海聚力传媒技术有限公司](https://www.pptv.com) | 2018-12-28 | 823E15E53DF1EAFED77A3D0423CB7418D5649AC7
[上海聚力传媒技术有限公司](https://www.pptv.com) | 2019-01-02 | 90B1CE5497A6DFC68F87B6CAB7A956A0409A915B
[上海聚力传媒技术有限公司](https://www.pptv.com) | 2020-01-26 | 15B8BD1976DAFD8A1C2611D036F5B9AC2FE9D8EA
[上海聚力传媒技术有限公司](https://www.pptv.com) | 2020-01-26 | 7C39B326AFB80CF774FE59890578B92B3E48A27A
[上海米提财富网络科技有限公司](http://browser.2144.com) | 2017-07-01 | 95BAC100E409014072B500E28B7AC0073414E9F7
[上海米提财富网络科技有限公司](http://browser.2144.com) | 2020-07-07 | 81667CEE1A77A7E11AEFCC9933AD430BE8377E28
[上海瑞创网络科技股份有限公司](https://www.2345.com) | 2011-05-11 | F83662D8EFFFE4CDD3F4B5160018042DF0D8A28F
[上海瑞创网络科技股份有限公司](https://www.2345.com) | 2012-05-16 | 8C8CF17990E27110FCBDADA70D741BEC4AECB72E
[上海瑞创网络科技股份有限公司](https://www.2345.com) | 2013-06-06 | 833FFF0273572C441E52B9538F0D92FF7D9A8C78
[上海瑞创网络科技股份有限公司](https://www.2345.com) | 2014-06-21 | 645E7A1C195EA2C8ED9E34AE1BF3CB9B06FD712E
上海旭岑投资合伙企业（有限合伙） | 2017-09-20 | 7145CF5777CE8FD9C5A001BB18F87F60F071C9E6
[深圳市任网游科技发展有限公司](http://www.topfreeweb.net) | 2018-07-23 | 61EFA27B38B12BEF9B26F891C0ED7032AB85EB57
[深圳市任网游科技发展有限公司](http://www.topfreeweb.net) | 2019-09-01 | 4F4E5A15719C6A78FCDF8AD7E9358EF06848BCD6
[深圳市为爱普信息技术有限公司](https://www.i4.cn) | 2019-07-21 | D3A0E1A69355E75069C9E4E448D63D7AEF84FB13
[中国电信股份有限公司](http://www.189.cn) | 2016-02-29 | 40B33FA24481DEF470BF2CDF88BABB8754C8489A
[中移互联网有限公司](https://www.10086.cn) | 2019-02-04 | 0F18C0EC4A65079550966AC3F4AB49314DBB89FB
[重庆重橙网络科技有限公司](https://www.flash.cn) | 2021-03-19 | C35475B7C720D8DCA480A4F1451BB0C597C81AE9

* **Organization** list

Name | Authority | Fingerprint
:---:|:---:|---
ABC | [Agricultural Bank of China](http://www.abchina.com) | 78D0CDF5752D1E5B58A674644CFE3499BF02F9EF
ABC TEST CA | [Agricultural Bank of China](http://www.abchina.com) | F18C39F8B5A3E9BADC811BBA7690E8D0143BD851
ABC2048 | [Agricultural Bank of China](http://www.abchina.com) | 6FAE9AD81467C5FCB93574670F52C8EF538F8B6D
Alibaba.com Corporation Root CA | [Alibaba Group](https://www.alibaba.com) | A7217F919843199C958C128449DD52D2723B0A8A
Alipay.com Corporation | [Alibaba Group](https://www.alibaba.com) | 89A2FB0E332BA7275FE712FEC669D746125B1F32
ALIPAY_ROOT | [Alibaba Group](https://www.alibaba.com) | 59864294A96B3E5C37C058E9D1FBDE5FF0C2E4EE
AnXin CA Root | [AnXin CA](http://www.anxinca.com) | 1D4A2E58C68F3F2D2659BC3BAB05CFA81F87B1E8
AnXin CA Root | [AnXin CA](http://www.anxinca.com) | AEF46A0478785188910C331A41B64879CB808156
BeiJing ROOT CA | [BEIJING CERTIFICATE AUTHORITY](https://www.bjca.org.cn) | EC98F4A5096282FB192FFB168A574236C5A7DC6C
BOCOMCA | [Bank of Communications](https://www.bankcomm.com) | 4571466B830EAC5FCDC22103B9733C1A15CE78AC
CCB CA ROOT | [China Construction Bank](http://www.ccb.com) | 3018E5D74DF29E3590F5BB8DF01AA7FC116BB4DE
CCB CA ROOT | [China Construction Bank](http://www.ccb.com) | 8582B4AF7491B3D16636EEB32D44993D7DEE6C40
CFCA | [China Financial Certification Authority](https://www.cfca.com.cn) | A9743B713E4109381622D3689AB5D9E1DC51B164
CFCA ACS CA | [China Financial Certification Authority](https://www.cfca.com.cn) | D2790F6BB0A3EF62C674A1AA76A619DF02B21B82
CFCA CS CA | [China Financial Certification Authority](https://www.cfca.com.cn) | D3FBFAA8A67FC9A2EADBF86AEB5D07A9D6AF322E
CFCA Operation CA3 | [China Financial Certification Authority](https://www.cfca.com.cn) | 5A3A3EA74AE5D29F25A670024949869D1222E42A
CFCA RCA | [China Financial Certification Authority](https://www.cfca.com.cn) | AE73DFF81CF24E50DD52CA1496E7EF94876061CB
CFCA Root CA | [China Financial Certification Authority](https://www.cfca.com.cn) | 31BD6AEF73031C5A49338E7A06040DD815EF7512
CFCA RSA RCA | [China Financial Certification Authority](https://www.cfca.com.cn) | 57C5CEBB53FBF181E0B13977AF864F1C13F11AA9
CFCA TEST RSA CA | [China Financial Certification Authority](https://www.cfca.com.cn) | B5DCF1C58E86DBED2EA2D217A5C28D11FD9254F0
China Trust Network | [iTrusChina](https://www.itrus.com.cn) | 7C88AE178AE6AB8E69C30AF586D84EF29B6E6AE3
China Trust Network | [iTrusChina](https://www.itrus.com.cn) | B39B0B24B156D8B6123CAF7BA249DC81F27E39FA
China Trust Network | [iTrusChina](https://www.itrus.com.cn) | C2CAEB0DC296FD50596BCA0F53C5364521167039
CWCA | [CWCA](http://www.cwca.com.cn) | 029A0990DC0B34838A6AAC9662A9A5E23DD7B554
CWCA | [CWCA](http://www.cwca.com.cn) | 5A48E00BE8C9F33BDCAE3F61700675B4A3A3B6F3
DongFang eTrust CA | [DongFang Electronic Certificate Center](https://toponeca.com) | 7AC8AD57C068F0D58442477EB5B0DE10AF09DFDA
eID MICRoot | [eID](https://eid.cn) | 6F5C880129BED8B05B14C391364FE5298E2ED5FA
GDCA Root CA | [GUANG DONG CERTIFICATE AUTHORITY](https://www.gdca.com.cn) | 6A9989CDCAB2B13D9849EF71A9089DE5F56512F9
GFA CA CERTIFICATE | [GFA](http://www.cacenter.com.cn) | A4BF39D18409E9F27B8833543E56B9434A603CFF
Guangxi ROOT CA | [GUANGXI CERTIFICATE AUTHORITY LTD.](http://www.gxca.com.cn) | B3FAACDA0FFE817C3FC25B8D35FEC05A92314BDC
HBCA | [HeBei Certificate Authority Co,.Ltd](http://www.hebca.com) | E67291FCE01AB748D5E473F5CA1C3915A7EC5C8E
HBCA | [HeBei Digital Certificate Authority Center Co,.Ltd](http://www.hbca.org.cn) | BFC9D110D97715711AF20C494329BF7D1951BD11
HNCA | [HENAN CERTIFICATE AUTHORITY](https://www.hnca.com.cn) | 3FF4124C794A11A26B49A14D005FD6D2BA5878F8
HNCA | [HENAN CERTIFICATE AUTHORITY](https://www.hnca.com.cn) | DAB0CA93310A2507A7407F4879BA56D105AAD3C2
ICBC | [Industrial and Commercial Bank of China Limited](http://www.icbc.com.cn) | E3F9043072BABF5E9C631960B34CCCF9FFC8BA41
ICBC Root CA | [Industrial and Commercial Bank of China Limited](http://www.icbc.com.cn) | 5A960203C10CFA8D42DD115B61154F98E2F617F7
IcbcCA | [Industrial and Commercial Bank of China Limited](http://www.icbc.com.cn) | A02A23D13576ECA35498DC69166A20651E203E31
iTrusChina Class 2 Root CA - G3 | [iTrusChina](https://www.itrus.com.cn) | FA28654EB75408CEE1A4044DC382A5CCD43CCC24
iTruschina CN Root CA-1 | [iTrusChina](https://www.itrus.com.cn) | 240A61A2577970625B9F0B81283C4AA4037217B1
iTruschina CN Root CA-2 | [iTrusChina](https://www.itrus.com.cn) | 46F168AF009C28C18F452EB85F5E8747892B3C8B
iTruschina CN Root CA-3 | [iTrusChina](https://www.itrus.com.cn) | 654E9FADD2032AE1B87D6263AF04FD7FEE38D57C
JSCA_ROOT | [JiangSu CA](http://www.jsca.com.cn) | 4389F7886936C6B6D5532562CBB5DA5B4DD2296B
JSCA_ROOT | [JiangSu CA](http://www.jsca.com.cn) | AA90ABA1EFA49F42772C7722F5A73A1C3936B811
JXCA | [JIANGXI DIGITAL CERTIFICATE AUTHORITY CO,.LTD](http://www.jxca.org.cn) | 7A538FBBDE8EFDC125700718CC9B4A4BD9BA17E8
LNCA | [LiaoNing Certificate Authority Center](http://www.lnca.org.cn) | 48AE45DE0AED6F9866F4D71A8867166D8DF783AD
MmpaymchCA | [WeChat](https://www.wechat.com) | C7902CB1970DE2D82FD71725FD3E805719918F47
NETCA Root ClassA | [CHINACOMSERVICE](http://www.cnca.net) | 2F6D7583B2CFD0F87698FB392C8B481058A280FB
peihua-CA | [PEIHUA ADCS](http://rd.peihua.cn) | 82C5EAF859B5857D5DECD1BE6491E34E582D5BD8
Personal ICBC CA | [Industrial and Commercial Bank of China Limited](http://www.icbc.com.cn) | 2ABC81B0D7D052F887965562BB10AA66A80F7674
ROOT CERTIFICATE FOR GFA TRUST NETWORK | [GFA PKI](http://www.gfapki.com.cn) | C2859A597104BFC25B52EC15899A1999738AE13F
ROOT CERTIFICATE FOR GFA TRUST NETWORK | [GFA PKI](http://www.gfapki.com.cn) | C49ED789F979213F0096060DF131B04EAADAC921
ROOTCA | [Office of the State Commercial Cryptography Administration](http://www.sca.gov.cn) | DBB84423C928ABE889D0E368FC3191D151DDB1AB
ShanXi Digital Certificate Authority | [ShanXi Digital Certificate Authority](http://www.sxca.com.cn) | 10CF1AAD52AE48E1249F9718C3DCF8FB27B12BF6
SZCA | [ShenZhen Certificate Authority Centre Co,.Ltd](http://www.szca.com.cn) | 90D7A97592F0A3E2165DE5DA23B57701D74A298D
SZCA | [ShenZhen Certificate Authority Centre Co,.Ltd](http://www.szca.com.cn) | B0049D436F27237EE59C746A1EF3C96A8E1B54AC
Tenpay.com Root CA | [Tencent](https://www.tenpay.com) | 56502166C0DE2488950491C90C7560E0E7AA7378
TianJinROOT | [Tian Jin CA](http://www.tj-ca.net) | 53826F5DEF4E3AD9FD73DCF1D04E110D6DF7FDD6
UTrust Root CA | [ChinaUTrust](http://www.chinautrust.com) | 5070A0E2FA1DB04C2ED63461ECE36307AB3A863B
xjcaRoot | [XIN JIANG CERTIFICATE AUTHORITY](https://www.xjca.com.cn) | 52A213B3CA8A5A5664D1BB9CF7A6A546C4E55973
ZJRoot | [ZheJiang Certificate Authority](http://www.zjca.com.cn) | 5809E86214B0C112FE08C1177D682EF5AAA5BF5F
ZJRoot | [ZheJiang Certificate Authority](http://www.zjca.com.cn) | D65F531088EF11DD9BFA2BE437C906D44F9E9659
福建省运营根 CA | [Fujian Digital Certificate Authority CO.,LTD](http://www.fjca.com.cn) | DD9DE879188E29AE9C6CEF546D6191B89A6B4F09
